/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.lootmodifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletTools;
import mcjty.rftoolsdim.modules.knowledge.items.LostKnowledgeItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class EndermanLootModifier
extends LootModifier {
    public static final MapCodec<EndermanLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(l -> l.conditions), (App)Codec.FLOAT.fieldOf("commonKnowledgeChance").forGetter(l -> Float.valueOf(l.commonKnowledgeChance)), (App)Codec.FLOAT.fieldOf("uncommonKnowledgeChance").forGetter(l -> Float.valueOf(l.uncommonKnowledgeChance)), (App)Codec.FLOAT.fieldOf("rareKnowledgeChance").forGetter(l -> Float.valueOf(l.rareKnowledgeChance)), (App)Codec.FLOAT.fieldOf("legendaryKnowledgeChance").forGetter(l -> Float.valueOf(l.legendaryKnowledgeChance)), (App)Codec.FLOAT.fieldOf("commonDimletChance").forGetter(l -> Float.valueOf(l.commonDimletChance)), (App)Codec.FLOAT.fieldOf("uncommonDimletChance").forGetter(l -> Float.valueOf(l.uncommonDimletChance)), (App)Codec.FLOAT.fieldOf("rareDimletChance").forGetter(l -> Float.valueOf(l.rareDimletChance)), (App)Codec.FLOAT.fieldOf("legendaryDimletChance").forGetter(l -> Float.valueOf(l.legendaryDimletChance))).apply((Applicative)instance, EndermanLootModifier::new));
    private final float commonKnowledgeChance;
    private final float uncommonKnowledgeChance;
    private final float rareKnowledgeChance;
    private final float legendaryKnowledgeChance;
    private final float commonDimletChance;
    private final float uncommonDimletChance;
    private final float rareDimletChance;
    private final float legendaryDimletChance;

    public EndermanLootModifier(LootItemCondition[] conditionsIn, float commonKnowledgeChance, float uncommonKnowledgeChance, float rareKnowledgeChance, float legendaryKnowledgeChance, float commonDimletChance, float uncommonDimletChance, float rareDimletChance, float legendaryDimletChance) {
        super(conditionsIn);
        this.commonKnowledgeChance = commonKnowledgeChance;
        this.uncommonKnowledgeChance = uncommonKnowledgeChance;
        this.rareKnowledgeChance = rareKnowledgeChance;
        this.legendaryKnowledgeChance = legendaryKnowledgeChance;
        this.commonDimletChance = commonDimletChance;
        this.uncommonDimletChance = uncommonDimletChance;
        this.rareDimletChance = rareDimletChance;
        this.legendaryDimletChance = legendaryDimletChance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        RandomSource random = context.getRandom();
        this.spawnKnowledge((List<ItemStack>)generatedLoot, context, random, this.commonKnowledgeChance, DimletRarity.COMMON);
        this.spawnKnowledge((List<ItemStack>)generatedLoot, context, random, this.uncommonKnowledgeChance, DimletRarity.UNCOMMON);
        this.spawnKnowledge((List<ItemStack>)generatedLoot, context, random, this.rareKnowledgeChance, DimletRarity.RARE);
        this.spawnKnowledge((List<ItemStack>)generatedLoot, context, random, this.legendaryKnowledgeChance, DimletRarity.LEGENDARY);
        this.spawnDimlet((List<ItemStack>)generatedLoot, context, random, this.commonDimletChance, DimletRarity.COMMON);
        this.spawnDimlet((List<ItemStack>)generatedLoot, context, random, this.uncommonDimletChance, DimletRarity.UNCOMMON);
        this.spawnDimlet((List<ItemStack>)generatedLoot, context, random, this.rareDimletChance, DimletRarity.RARE);
        this.spawnDimlet((List<ItemStack>)generatedLoot, context, random, this.legendaryDimletChance, DimletRarity.LEGENDARY);
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    private void spawnKnowledge(List<ItemStack> generatedLoot, LootContext context, RandomSource random, float chance, DimletRarity rarity) {
        ItemStack stack;
        if (random.nextFloat() < chance && !(stack = LostKnowledgeItem.createUnresearchedLostKnowledge(rarity)).isEmpty()) {
            generatedLoot.add(stack);
        }
    }

    private void spawnDimlet(List<ItemStack> generatedLoot, LootContext context, RandomSource random, float chance, DimletRarity rarity) {
        DimletKey key;
        if (random.nextFloat() < chance && (key = DimletDictionary.get().getRandomDimlet(rarity, random)) != null) {
            generatedLoot.add(DimletTools.getDimletStack(key));
        }
    }
}

