/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.data;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsdim.compat.LostCityCompat;
import mcjty.rftoolsdim.dimension.AdminDimletType;
import mcjty.rftoolsdim.modules.dimlets.DimletModule;
import mcjty.rftoolsdim.modules.dimlets.data.DimletData;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.dimlets.items.DimletItem;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import mcjty.rftoolsdim.modules.essences.blocks.BiomeAbsorberTileEntity;
import mcjty.rftoolsdim.modules.essences.blocks.BlockAbsorberTileEntity;
import mcjty.rftoolsdim.modules.essences.blocks.FluidAbsorberTileEntity;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class DimletTools {
    public static String getDimletDescription(ItemStack stack) {
        DimletKey key = DimletTools.getDimletKey(stack);
        if (key == null) {
            return "<Unknown>";
        }
        return DimletTools.getReadableName(key);
    }

    public static String getDimletRarity(ItemStack stack) {
        DimletKey key = DimletTools.getDimletKey(stack);
        if (key == null) {
            return "<Unknown>";
        }
        DimletSettings settings = DimletDictionary.get().getSettings(key);
        if (settings != null) {
            DimletRarity rarity = settings.getRarity();
            return rarity.name();
        }
        return "<Unknown>";
    }

    public static String getDimletCost(ItemStack stack) {
        DimletKey key = DimletTools.getDimletKey(stack);
        if (key == null) {
            return "<Unknown>";
        }
        DimletSettings settings = DimletDictionary.get().getSettings(key);
        if (settings != null) {
            int createCost = settings.getCreateCost();
            int maintainCost = settings.getMaintainCost();
            int tickCost = settings.getTickCost();
            return "C " + createCost + ", M " + maintainCost + ", T " + tickCost;
        }
        return "<Unknown>";
    }

    private static DimletItem getDimletItem(DimletType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case DimletType.TERRAIN -> (DimletItem)((Object)DimletModule.TERRAIN_DIMLET.get());
            case DimletType.ATTRIBUTE -> (DimletItem)((Object)DimletModule.ATTRIBUTE_DIMLET.get());
            case DimletType.BIOME_CONTROLLER -> (DimletItem)((Object)DimletModule.BIOME_CONTROLLER_DIMLET.get());
            case DimletType.BIOME_CATEGORY -> (DimletItem)((Object)DimletModule.BIOME_CATEGORY_DIMLET.get());
            case DimletType.BIOME -> (DimletItem)((Object)DimletModule.BIOME_DIMLET.get());
            case DimletType.FEATURE -> (DimletItem)((Object)DimletModule.FEATURE_DIMLET.get());
            case DimletType.STRUCTURE -> (DimletItem)((Object)DimletModule.STRUCTURE_DIMLET.get());
            case DimletType.TIME -> (DimletItem)((Object)DimletModule.TIME_DIMLET.get());
            case DimletType.BLOCK -> (DimletItem)((Object)DimletModule.BLOCK_DIMLET.get());
            case DimletType.TAG -> (DimletItem)((Object)DimletModule.TAG_DIMLET.get());
            case DimletType.FLUID -> (DimletItem)((Object)DimletModule.FLUID_DIMLET.get());
            case DimletType.DIGIT -> (DimletItem)((Object)DimletModule.DIGIT_DIMLET.get());
            case DimletType.ADMIN -> (DimletItem)((Object)DimletModule.ADMIN_DIMLET.get());
            case DimletType.SKY -> (DimletItem)((Object)DimletModule.SKY_DIMLET.get());
        };
    }

    private static DimletItem getEmptyDimletItem(DimletType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case DimletType.TERRAIN -> (DimletItem)((Object)DimletModule.EMPTY_TERRAIN_DIMLET.get());
            case DimletType.ATTRIBUTE -> (DimletItem)((Object)DimletModule.EMPTY_ATTRIBUTE_DIMLET.get());
            case DimletType.BIOME_CONTROLLER -> (DimletItem)((Object)DimletModule.EMPTY_BIOME_CONTROLLER_DIMLET.get());
            case DimletType.BIOME_CATEGORY -> (DimletItem)((Object)DimletModule.EMPTY_BIOME_CATEGORY_DIMLET.get());
            case DimletType.BIOME -> (DimletItem)((Object)DimletModule.EMPTY_BIOME_DIMLET.get());
            case DimletType.FEATURE -> (DimletItem)((Object)DimletModule.EMPTY_FEATURE_DIMLET.get());
            case DimletType.STRUCTURE -> (DimletItem)((Object)DimletModule.EMPTY_STRUCTURE_DIMLET.get());
            case DimletType.TIME -> (DimletItem)((Object)DimletModule.EMPTY_TIME_DIMLET.get());
            case DimletType.BLOCK -> (DimletItem)((Object)DimletModule.EMPTY_BLOCK_DIMLET.get());
            case DimletType.TAG -> (DimletItem)((Object)DimletModule.EMPTY_TAG_DIMLET.get());
            case DimletType.SKY -> (DimletItem)((Object)DimletModule.EMPTY_SKY_DIMLET.get());
            case DimletType.FLUID -> (DimletItem)((Object)DimletModule.EMPTY_FLUID_DIMLET.get());
            case DimletType.DIGIT -> null;
            case DimletType.ADMIN -> null;
        };
    }

    @Nullable
    public static DimletKey getDimletKey(ItemStack stack) {
        DimletData data;
        DimletType type;
        if (stack.getItem() instanceof DimletItem && (type = ((DimletItem)stack.getItem()).getType()) != null && (data = (DimletData)stack.get(DimletModule.ITEM_DIMLET_DATA)) != null) {
            String name = data.name();
            return new DimletKey(type, name);
        }
        return null;
    }

    @Nonnull
    public static ItemStack getDimletStack(DimletKey key) {
        DimletItem item = DimletTools.getDimletItem(key.type());
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.set(DimletModule.ITEM_DIMLET_DATA, (Object)new DimletData(key.key()));
        return stack;
    }

    @Nonnull
    public static ItemStack getEmptyDimletStack(DimletType type) {
        DimletItem item = DimletTools.getEmptyDimletItem(type);
        return new ItemStack((ItemLike)item);
    }

    public static ItemStack getNeededMemoryPart(DimletKey key) {
        DimletSettings settings = DimletDictionary.get().getSettings(key);
        if (settings == null) {
            return ItemStack.EMPTY;
        }
        DimletRarity rarity = settings.getRarity();
        if (rarity == null) {
            return ItemStack.EMPTY;
        }
        return switch (rarity) {
            default -> throw new MatchException(null, null);
            case DimletRarity.COMMON -> new ItemStack((ItemLike)DimletModule.PART_MEMORY_0.get());
            case DimletRarity.UNCOMMON -> new ItemStack((ItemLike)DimletModule.PART_MEMORY_1.get());
            case DimletRarity.RARE -> new ItemStack((ItemLike)DimletModule.PART_MEMORY_2.get());
            case DimletRarity.LEGENDARY -> new ItemStack((ItemLike)DimletModule.PART_MEMORY_3.get());
        };
    }

    public static ItemStack getNeededEnergyPart(DimletKey key) {
        DimletSettings settings = DimletDictionary.get().getSettings(key);
        if (settings == null) {
            return ItemStack.EMPTY;
        }
        DimletRarity rarity = settings.getRarity();
        if (rarity == null) {
            return ItemStack.EMPTY;
        }
        return switch (rarity) {
            default -> throw new MatchException(null, null);
            case DimletRarity.COMMON -> new ItemStack((ItemLike)DimletModule.PART_ENERGY_0.get());
            case DimletRarity.UNCOMMON -> new ItemStack((ItemLike)DimletModule.PART_ENERGY_1.get());
            case DimletRarity.RARE -> new ItemStack((ItemLike)DimletModule.PART_ENERGY_2.get());
            case DimletRarity.LEGENDARY -> new ItemStack((ItemLike)DimletModule.PART_ENERGY_3.get());
        };
    }

    public static ItemStack getNeededEssence(DimletKey key, @Nonnull DimletSettings settings) {
        if (!settings.getEssence().isEmpty()) {
            return settings.getEssence();
        }
        return switch (key.type()) {
            default -> throw new MatchException(null, null);
            case DimletType.TERRAIN -> ItemStack.EMPTY;
            case DimletType.ATTRIBUTE -> ItemStack.EMPTY;
            case DimletType.BIOME_CONTROLLER -> ItemStack.EMPTY;
            case DimletType.BIOME_CATEGORY -> ItemStack.EMPTY;
            case DimletType.BIOME -> new ItemStack((ItemLike)EssencesModule.BIOME_ABSORBER_ITEM.get());
            case DimletType.FEATURE -> ItemStack.EMPTY;
            case DimletType.STRUCTURE -> new ItemStack((ItemLike)EssencesModule.STRUCTURE_ABSORBER_ITEM.get());
            case DimletType.TIME -> ItemStack.EMPTY;
            case DimletType.BLOCK -> new ItemStack((ItemLike)EssencesModule.BLOCK_ABSORBER_ITEM.get());
            case DimletType.TAG -> ItemStack.EMPTY;
            case DimletType.FLUID -> new ItemStack((ItemLike)EssencesModule.FLUID_ABSORBER_ITEM.get());
            case DimletType.DIGIT -> ItemStack.EMPTY;
            case DimletType.ADMIN -> ItemStack.EMPTY;
            case DimletType.SKY -> ItemStack.EMPTY;
        };
    }

    public static String getReadableName(DimletKey dimletKey) {
        return switch (dimletKey.type()) {
            default -> throw new MatchException(null, null);
            case DimletType.TERRAIN -> dimletKey.key().toLowerCase();
            case DimletType.ATTRIBUTE -> dimletKey.key().toLowerCase();
            case DimletType.BIOME_CONTROLLER -> dimletKey.key().toLowerCase();
            case DimletType.BIOME_CATEGORY -> dimletKey.key().toLowerCase();
            case DimletType.BIOME -> DimletTools.getReadableNameBiome(dimletKey);
            case DimletType.SKY -> dimletKey.key().toLowerCase();
            case DimletType.FEATURE -> dimletKey.key().toLowerCase();
            case DimletType.STRUCTURE -> ResourceLocation.parse((String)dimletKey.key()).getPath();
            case DimletType.TIME -> dimletKey.key().toLowerCase();
            case DimletType.BLOCK -> DimletTools.getReadableNameBlock(dimletKey);
            case DimletType.TAG -> dimletKey.key().toLowerCase();
            case DimletType.FLUID -> DimletTools.getReadableNameFluid(dimletKey);
            case DimletType.DIGIT -> dimletKey.key();
            case DimletType.ADMIN -> dimletKey.key();
        };
    }

    @NotNull
    private static String getReadableNameFluid(DimletKey dimletKey) {
        Fluid fluid = Tools.getFluid((ResourceLocation)ResourceLocation.parse((String)dimletKey.key()));
        if (fluid != null) {
            String modName = Tools.getModName((Fluid)fluid);
            if ("minecraft".equalsIgnoreCase(modName)) {
                return I18n.get((String)fluid.defaultFluidState().createLegacyBlock().getBlock().getDescriptionId(), (Object[])new Object[0]);
            }
            return I18n.get((String)fluid.defaultFluidState().createLegacyBlock().getBlock().getDescriptionId(), (Object[])new Object[0]) + " (" + modName + ")";
        }
        return "<Invalid " + dimletKey.key() + ">";
    }

    @NotNull
    private static String getReadableNameBlock(DimletKey dimletKey) {
        Block block = Tools.getBlock((ResourceLocation)ResourceLocation.parse((String)dimletKey.key()));
        if (block != null) {
            String modName = Tools.getModName((Block)block);
            if ("minecraft".equalsIgnoreCase(modName)) {
                return I18n.get((String)block.getDescriptionId(), (Object[])new Object[0]);
            }
            return I18n.get((String)block.getDescriptionId(), (Object[])new Object[0]) + " (" + modName + ")";
        }
        return "<Invalid " + dimletKey.key() + ">";
    }

    @NotNull
    private static String getReadableNameBiome(DimletKey dimletKey) {
        ResourceLocation id = ResourceLocation.parse((String)dimletKey.key());
        String trans = "biome." + id.getNamespace() + "." + id.getPath();
        return I18n.get((String)trans, (Object[])new Object[0]);
    }

    public static boolean isFullEssence(ItemStack stack, ItemStack desired, String desiredKey) {
        if (ItemStack.isSameItem((ItemStack)stack, (ItemStack)desired)) {
            if (stack.getItem() == EssencesModule.BIOME_ABSORBER_ITEM.get()) {
                ResourceLocation biome = BiomeAbsorberTileEntity.getBiome(stack);
                if (Objects.equals(desiredKey, biome == null ? null : biome.toString())) {
                    return BiomeAbsorberTileEntity.getProgress(stack) >= 100;
                }
            } else if (stack.getItem() == EssencesModule.BLOCK_ABSORBER_ITEM.get()) {
                ResourceLocation block = BlockAbsorberTileEntity.getBlock(stack);
                if (Objects.equals(desiredKey, block == null ? null : block.toString())) {
                    return BlockAbsorberTileEntity.getProgress(stack) >= 100;
                }
            } else if (stack.getItem() == EssencesModule.FLUID_ABSORBER_ITEM.get()) {
                ResourceLocation fluid = FluidAbsorberTileEntity.getFluid(stack);
                if (Objects.equals(desiredKey, fluid == null ? null : fluid.toString())) {
                    return FluidAbsorberTileEntity.getProgress(stack) >= 100;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static boolean isOwnerDimlet(DimletKey dimletKey) {
        return dimletKey != null && dimletKey.type() == DimletType.ADMIN && dimletKey.key().equals(AdminDimletType.OWNER.name().toLowerCase());
    }

    public static boolean isValidDimlet(RegistryAccess access, DimletKey key) {
        return switch (key.type()) {
            case DimletType.BIOME -> DimletTools.isValidBiome(access, key);
            case DimletType.BLOCK -> DimletTools.isValidBlock(key);
            case DimletType.FLUID -> DimletTools.isValidFluid(key);
            case DimletType.ADMIN -> DimletTools.isValidAttribute(key);
            default -> true;
        };
    }

    private static boolean isValidAttribute(DimletKey key) {
        if ("cities".equals(key.key())) {
            return LostCityCompat.hasLostCities();
        }
        return true;
    }

    private static boolean isValidBiome(RegistryAccess access, DimletKey key) {
        return ((Registry)access.registry(Registries.BIOME).get()).containsKey(ResourceLocation.parse((String)key.key()));
    }

    private static boolean isValidBlock(DimletKey key) {
        Block value = Tools.getBlock((ResourceLocation)ResourceLocation.parse((String)key.key()));
        return value != null && value != Blocks.AIR;
    }

    private static boolean isValidFluid(DimletKey key) {
        Fluid fluid = Tools.getFluid((ResourceLocation)ResourceLocation.parse((String)key.key()));
        return fluid != null && fluid.defaultFluidState().createLegacyBlock().getBlock() != Blocks.AIR;
    }
}

