/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.JSonTools;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class DimletSettings {
    private final DimletRarity rarity;
    private final int createCost;
    private final int maintainCost;
    private final int tickCost;
    private final boolean worldgen;
    private final boolean dimlet;
    private final ItemStack essence;

    private DimletSettings(Builder builder) {
        this.rarity = builder.rarity;
        this.createCost = builder.createCost;
        this.maintainCost = builder.maintainCost;
        this.tickCost = builder.tickCost;
        this.worldgen = builder.worldgen;
        this.dimlet = builder.dimlet;
        this.essence = builder.essence;
        if (this.rarity == null) {
            throw new IllegalStateException("Dimlet without rarity!");
        }
    }

    public DimletSettings(RegistryFriendlyByteBuf buf) {
        this.rarity = DimletRarity.values()[buf.readInt()];
        this.createCost = buf.readInt();
        this.maintainCost = buf.readInt();
        this.tickCost = buf.readInt();
        this.worldgen = buf.readBoolean();
        this.dimlet = buf.readBoolean();
        this.essence = NetworkTools.readItemStack((RegistryFriendlyByteBuf)buf);
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.rarity.ordinal());
        buf.writeInt(this.createCost);
        buf.writeInt(this.maintainCost);
        buf.writeInt(this.tickCost);
        buf.writeBoolean(this.worldgen);
        buf.writeBoolean(this.dimlet);
        NetworkTools.writeItemStack((RegistryFriendlyByteBuf)buf, (ItemStack)this.essence);
    }

    public void buildElement(JsonObject jsonObject) {
        if (this.rarity != null) {
            jsonObject.add("rarity", (JsonElement)new JsonPrimitive(this.rarity.name().toLowerCase()));
        }
        jsonObject.add("create", (JsonElement)new JsonPrimitive((Number)this.createCost));
        jsonObject.add("maintain", (JsonElement)new JsonPrimitive((Number)this.maintainCost));
        jsonObject.add("ticks", (JsonElement)new JsonPrimitive((Number)this.tickCost));
        jsonObject.add("worldgen", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.worldgen)));
        jsonObject.add("dimlet", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.dimlet)));
        if (!this.essence.isEmpty()) {
            JsonElement json = JSonTools.itemStackToJson((ItemStack)this.essence);
            jsonObject.add("essence", json);
        }
    }

    public static DimletSettings parse(JsonObject jsonObject) {
        Builder builder = new Builder();
        builder.rarity(DimletRarity.byName(((JsonElement)JSonTools.getElement((JsonObject)jsonObject, (String)"rarity").orElseThrow(() -> new IllegalStateException("Missing rarity"))).getAsString()));
        JSonTools.getElement((JsonObject)jsonObject, (String)"create").ifPresent(e -> builder.createCost(e.getAsInt()));
        JSonTools.getElement((JsonObject)jsonObject, (String)"maintain").ifPresent(e -> builder.maintainCost(e.getAsInt()));
        JSonTools.getElement((JsonObject)jsonObject, (String)"ticks").ifPresent(e -> builder.tickCost(e.getAsInt()));
        JSonTools.getElement((JsonObject)jsonObject, (String)"worldgen").ifPresent(e -> builder.worldgen(e.getAsBoolean()));
        JSonTools.getElement((JsonObject)jsonObject, (String)"dimlet").ifPresent(e -> builder.dimlet(e.getAsBoolean()));
        if (jsonObject.has("essence")) {
            try {
                builder.essence(JSonTools.jsonToItemStack((JsonObject)jsonObject.getAsJsonObject("essence")));
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return builder.build();
    }

    public ItemStack getEssence() {
        return this.essence;
    }

    public DimletRarity getRarity() {
        return this.rarity;
    }

    public int getCreateCost() {
        return this.createCost;
    }

    public int getMaintainCost() {
        return this.maintainCost;
    }

    public int getTickCost() {
        return this.tickCost;
    }

    public boolean isWorldgen() {
        return this.worldgen;
    }

    public boolean isDimlet() {
        return this.dimlet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder create(DimletRarity rarity, int createCost, int maintainCost, int tickCost) {
        return DimletSettings.builder().rarity(rarity).createCost(createCost).maintainCost(maintainCost).tickCost(tickCost).worldgen(true).dimlet(true);
    }

    public static class Builder {
        private DimletRarity rarity;
        private Integer createCost;
        private Integer maintainCost;
        private Integer tickCost;
        private Boolean worldgen;
        private Boolean dimlet;
        private ItemStack essence = ItemStack.EMPTY;

        private Builder() {
        }

        public Builder complete() {
            if (this.rarity == null) {
                this.rarity = DimletRarity.COMMON;
            }
            if (this.createCost == null) {
                this.createCost = 1;
            }
            if (this.maintainCost == null) {
                this.maintainCost = 1;
            }
            if (this.tickCost == null) {
                this.tickCost = 1;
            }
            if (this.worldgen == null) {
                this.worldgen = false;
            }
            if (this.dimlet == null) {
                this.dimlet = false;
            }
            return this;
        }

        public Builder essence(ItemStack stack) {
            this.essence = stack;
            return this;
        }

        public Builder rarity(DimletRarity rarity) {
            this.rarity = rarity;
            return this;
        }

        public Builder createCost(int createCost) {
            this.createCost = createCost;
            return this;
        }

        public Builder maintainCost(int maintainCost) {
            this.maintainCost = maintainCost;
            return this;
        }

        public Builder tickCost(int tickCost) {
            this.tickCost = tickCost;
            return this;
        }

        public Builder worldgen(boolean worldgen) {
            this.worldgen = worldgen;
            return this;
        }

        public Builder dimlet(boolean dimlet) {
            this.dimlet = dimlet;
            return this;
        }

        public DimletSettings build() {
            return new DimletSettings(this);
        }
    }
}

