/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.data;

import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import net.minecraft.network.FriendlyByteBuf;

public record DimletKey(DimletType type, String key) implements Comparable<DimletKey>
{
    public static DimletKey create(FriendlyByteBuf buf) {
        return new DimletKey(DimletType.values()[buf.readInt()], buf.readUtf(Short.MAX_VALUE));
    }

    public static DimletKey create(String serialized) {
        String[] split = serialized.split("#");
        return new DimletKey(DimletType.byName(split[0]), split[1]);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeUtf(this.key);
    }

    @Override
    public int compareTo(DimletKey dimletKey) {
        if (dimletKey.type().equals((Object)this.type)) {
            return this.key.compareTo(dimletKey.key);
        }
        return this.type.name().compareTo(dimletKey.type.name());
    }
}

