/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimensionbuilder.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsdim.dimension.data.ClientDimensionData;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.DimensionSettings;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.dimension.descriptor.CompiledFeature;
import mcjty.rftoolsdim.dimension.descriptor.DescriptorError;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import mcjty.rftoolsdim.dimension.terraintypes.RFToolsChunkGenerator;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderModule;
import mcjty.rftoolsdim.modules.dimensionbuilder.data.RealizedTabData;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class RealizedDimensionTab
extends Item {
    public RealizedDimensionTab() {
        super(new Item.Properties().stacksTo(1));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide && player.isShiftKeyDown()) {
            RealizedTabData tab = (RealizedTabData)stack.getOrDefault(DimensionBuilderModule.ITEM_REALIZED_TAB_DATA, (Object)RealizedTabData.DEFAULT);
            Logging.message((Player)player, (String)tab.descriptor());
            if (tab.dimension().isPresent()) {
                ResourceLocation dimension = tab.dimension().get();
                DimensionData data = PersistantDimensionManager.get(world).getData(dimension);
                if (data != null) {
                    player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.BLUE) + "Energy: " + String.valueOf(ChatFormatting.WHITE) + data.getEnergy())), false);
                    DimensionDescriptor descriptor = data.getDescriptor();
                    descriptor.dump(player);
                    player.displayClientMessage((Component)ComponentFactory.literal((String)"-----------------------------"), false);
                    DimensionDescriptor randomized = data.getRandomizedDescriptor();
                    randomized.dump(player);
                }
                ResourceKey id = LevelTools.getId((ResourceLocation)dimension);
                ServerLevel serverWorld = ServerLifecycleHooks.getCurrentServer().getLevel(id);
                ChunkGenerator generator = serverWorld.getChunkSource().getGenerator();
                if (generator instanceof RFToolsChunkGenerator) {
                    DimensionSettings settings = ((RFToolsChunkGenerator)generator).getDimensionSettings();
                    player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.BLUE) + "Seed: " + String.valueOf(ChatFormatting.WHITE) + settings.getSeed())), false);
                }
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext context, @Nonnull List<Component> list, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, list, flagIn);
        RealizedTabData tab = (RealizedTabData)stack.get(DimensionBuilderModule.ITEM_REALIZED_TAB_DATA);
        if (tab != null) {
            ResourceLocation dimension = tab.dimension().orElse(null);
            if (dimension != null) {
                list.add((Component)ComponentFactory.literal((String)("Name: " + dimension.getPath())).withStyle(ChatFormatting.BLUE));
            } else if (tab.name().isPresent()) {
                String name = tab.name().get();
                list.add((Component)ComponentFactory.literal((String)("Name: " + name)).withStyle(ChatFormatting.BLUE));
            }
            if (SafeClientTools.isSneaking()) {
                String descriptionString = tab.descriptor();
                String randomizedString = tab.randomized();
                this.constructDescriptionHelp(list, descriptionString, randomizedString);
            } else {
                list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.GREEN) + "    <Press Shift>")));
            }
            int ticksLeft = tab.ticksLeft();
            if (ticksLeft == 0) {
                long power = ClientDimensionData.get().getPower(dimension);
                long max = ClientDimensionData.get().getMaxPower(dimension);
                list.add((Component)ComponentFactory.literal((String)"Dimension ready!").withStyle(ChatFormatting.BLUE));
                int maintainCost = tab.rfMaintainCost();
                list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "    Maintenance cost: " + maintainCost + " RF/tick")));
                list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "    Current power: " + power + " (" + max + ")")));
            } else {
                int createCost = tab.rfCreateCost();
                int maintainCost = tab.rfMaintainCost();
                int tickCost = tab.tickCost();
                int percentage = 0;
                if (tickCost != 0) {
                    percentage = (tickCost - ticksLeft) * 100 / tickCost;
                }
                list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.BLUE) + "Dimension progress: " + percentage + "%")));
                list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "    Creation cost: " + createCost + " RF/tick")));
                list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "    Maintenance cost: " + maintainCost + " RF/tick")));
                list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "    Tick cost: " + tickCost + " ticks")));
            }
        }
    }

    private void constructDescriptionHelp(List<Component> list, String descriptionString, String randomizedString) {
        DimensionDescriptor descriptor = new DimensionDescriptor();
        descriptor.read(descriptionString);
        DimensionDescriptor randomizedDescriptor = new DimensionDescriptor();
        if (!randomizedString.isEmpty()) {
            randomizedDescriptor.read(randomizedString);
        }
        CompiledDescriptor compiledDescriptor = new CompiledDescriptor();
        try {
            compiledDescriptor.compile(descriptor, randomizedDescriptor);
            if (compiledDescriptor.getTerrainType() != null) {
                list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.GREEN) + "    Terrain: " + String.valueOf(ChatFormatting.WHITE) + compiledDescriptor.getTerrainType().getName())));
            }
            if (compiledDescriptor.getBiomeControllerType() != null) {
                list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.GREEN) + "    Biome Controller: " + String.valueOf(ChatFormatting.WHITE) + compiledDescriptor.getBiomeControllerType().getName())));
            }
            if (compiledDescriptor.getTimeType() != null) {
                list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.GREEN) + "    Time: " + String.valueOf(ChatFormatting.WHITE) + compiledDescriptor.getTimeType().getName())));
            }
            for (CompiledFeature feature : compiledDescriptor.getFeatures()) {
                list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.GREEN) + "    Feature: " + String.valueOf(ChatFormatting.WHITE) + feature.getFeatureType().getName())));
            }
        }
        catch (DescriptorError error) {
            list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "Parse error: " + error.getMessage())));
        }
    }
}

