/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimensionbuilder.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.IEnergyItem;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.dimension.DimensionConfig;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderConfig;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderModule;
import mcjty.rftoolsdim.modules.dimensionbuilder.data.PhasedFieldGeneratorData;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class PhasedFieldGenerator
extends Item
implements IEnergyItem,
ITooltipSettings {
    private final Lazy<TooltipBuilder> tooltipBuilder = Lazy.of(() -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"power", this::getEnergyString)}));

    private String getEnergyString(ItemStack stack) {
        return Long.toString(PhasedFieldGeneratorData.getEnergy(stack));
    }

    public PhasedFieldGenerator() {
        super(RFToolsDim.setup.defaultProperties().stacksTo(1));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.isEmpty() != newStack.isEmpty()) {
            return true;
        }
        return oldStack.getItem() != newStack.getItem();
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext context, @Nonnull List<Component> list, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, list, flagIn);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), stack, list, flagIn);
    }

    public long receiveEnergyL(ItemStack container, long maxReceive, boolean simulate) {
        long energy = PhasedFieldGeneratorData.getEnergy(container);
        long energyReceived = Math.min(this.getMaxEnergyStoredL(container) - energy, Math.min((Long)DimensionBuilderConfig.PHASEDFIELD_RECEIVEPERTICK.get(), maxReceive));
        if (!simulate) {
            PhasedFieldGeneratorData.setEnergy(container, energy += energyReceived);
        }
        return energyReceived;
    }

    public long extractEnergyL(ItemStack container, long maxExtract, boolean simulate) {
        long energy = PhasedFieldGeneratorData.getEnergy(container);
        long energyExtracted = Math.min(energy, Math.min((Long)DimensionBuilderConfig.PHASEDFIELD_CONSUMEPERTICK.get() * 10L, maxExtract));
        if (!simulate) {
            PhasedFieldGeneratorData.setEnergy(container, energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public long getEnergyStoredL(ItemStack container) {
        return PhasedFieldGeneratorData.getEnergy(container);
    }

    public long getMaxEnergyStoredL(ItemStack container) {
        return (Long)DimensionBuilderConfig.PHASEDFIELD_MAXENERGY.get();
    }

    public static boolean checkValidPhasedFieldGenerator(Player player, boolean consume, int tickCost) {
        Inventory inventory = player.getInventory();
        for (int i = 0; i < Inventory.getSelectionSize(); ++i) {
            int toConsume;
            PhasedFieldGenerator pfg;
            int energyStored;
            ItemStack slot = inventory.getItem(i);
            if (slot.isEmpty() || slot.getItem() != DimensionBuilderModule.PHASED_FIELD_GENERATOR.get() || (energyStored = (pfg = (PhasedFieldGenerator)slot.getItem()).getEnergyStored(slot)) < (toConsume = (Boolean)DimensionConfig.ENABLE_DYNAMIC_PHASECOST.get() != false ? (int)((double)(10 * tickCost) * (Double)DimensionConfig.DYNAMIC_PHASECOST_AMOUNT.get()) : (int)(10L * (Long)DimensionBuilderConfig.PHASEDFIELD_CONSUMEPERTICK.get()))) continue;
            if (consume) {
                pfg.extractEnergy(slot, toConsume, false);
            }
            return true;
        }
        return false;
    }

    public IEnergyStorage createEnergyStorage(final ItemStack container) {
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return (int)PhasedFieldGenerator.this.receiveEnergyL(container, maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return (int)PhasedFieldGenerator.this.extractEnergyL(container, maxExtract, simulate);
            }

            public int getEnergyStored() {
                return (int)PhasedFieldGenerator.this.getEnergyStoredL(container);
            }

            public int getMaxEnergyStored() {
                return (int)PhasedFieldGenerator.this.getMaxEnergyStoredL(container);
            }

            public boolean canExtract() {
                return false;
            }

            public boolean canReceive() {
                return true;
            }
        };
    }
}

