/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimensionbuilder.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mcjty.lib.varia.CompositeStreamCodec;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record RealizedTabData(Optional<ResourceLocation> dimension, Optional<String> name, String descriptor, String randomized, long forcedSeed, int ticksLeft, int rfCreateCost, int rfMaintainCost, int tickCost) {
    public static final RealizedTabData DEFAULT = new RealizedTabData(Optional.empty(), Optional.empty(), "", "", 0L, 0, 0, 0, 0);
    public static final Codec<RealizedTabData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.optionalFieldOf("dimension").forGetter(RealizedTabData::dimension), (App)Codec.STRING.optionalFieldOf("name").forGetter(RealizedTabData::name), (App)Codec.STRING.fieldOf("descriptor").forGetter(RealizedTabData::descriptor), (App)Codec.STRING.fieldOf("randomized").forGetter(RealizedTabData::randomized), (App)Codec.LONG.fieldOf("forcedSeed").forGetter(RealizedTabData::forcedSeed), (App)Codec.INT.fieldOf("ticksLeft").forGetter(RealizedTabData::ticksLeft), (App)Codec.INT.fieldOf("rfCreateCost").forGetter(RealizedTabData::rfCreateCost), (App)Codec.INT.fieldOf("rfMaintainCost").forGetter(RealizedTabData::rfMaintainCost), (App)Codec.INT.fieldOf("tickCost").forGetter(RealizedTabData::tickCost)).apply((Applicative)inst, RealizedTabData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RealizedTabData> STREAM_CODEC = CompositeStreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), RealizedTabData::dimension, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), RealizedTabData::name, (StreamCodec)ByteBufCodecs.STRING_UTF8, RealizedTabData::descriptor, (StreamCodec)ByteBufCodecs.STRING_UTF8, RealizedTabData::randomized, (StreamCodec)ByteBufCodecs.VAR_LONG, RealizedTabData::forcedSeed, (StreamCodec)ByteBufCodecs.INT, RealizedTabData::ticksLeft, (StreamCodec)ByteBufCodecs.INT, RealizedTabData::rfCreateCost, (StreamCodec)ByteBufCodecs.INT, RealizedTabData::rfMaintainCost, (StreamCodec)ByteBufCodecs.INT, RealizedTabData::tickCost, RealizedTabData::new);

    public RealizedTabData withTicksLeft(int ticksLeft) {
        return new RealizedTabData(this.dimension, this.name, this.descriptor, this.randomized, this.forcedSeed, ticksLeft, this.rfCreateCost, this.rfMaintainCost, this.tickCost);
    }

    public RealizedTabData withDimension(ResourceLocation dimension) {
        return new RealizedTabData(Optional.ofNullable(dimension), this.name, this.descriptor, this.randomized, this.forcedSeed, this.ticksLeft, this.rfCreateCost, this.rfMaintainCost, this.tickCost);
    }

    public RealizedTabData withRfMaintainCost(int rfMaintainCost) {
        return new RealizedTabData(this.dimension, this.name, this.descriptor, this.randomized, this.forcedSeed, this.ticksLeft, this.rfCreateCost, rfMaintainCost, this.tickCost);
    }

    public RealizedTabData withName(String name) {
        return new RealizedTabData(this.dimension, Optional.ofNullable(name), this.descriptor, this.randomized, this.forcedSeed, this.ticksLeft, this.rfCreateCost, this.rfMaintainCost, this.tickCost);
    }

    public RealizedTabData withDescriptor(String descriptor) {
        return new RealizedTabData(this.dimension, this.name, descriptor, this.randomized, this.forcedSeed, this.ticksLeft, this.rfCreateCost, this.rfMaintainCost, this.tickCost);
    }

    public RealizedTabData withTickCost(int tickCost) {
        return new RealizedTabData(this.dimension, this.name, this.descriptor, this.randomized, this.forcedSeed, this.ticksLeft, this.rfCreateCost, this.rfMaintainCost, tickCost);
    }

    public RealizedTabData withRfCreateCost(int rfCreateCost) {
        return new RealizedTabData(this.dimension, this.name, this.descriptor, this.randomized, this.forcedSeed, this.ticksLeft, rfCreateCost, this.rfMaintainCost, this.tickCost);
    }
}

