/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimensionbuilder.client;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.client.RenderSettings;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderModule;
import mcjty.rftoolsdim.modules.dimensionbuilder.blocks.DimensionBuilderTileEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class DimensionBuilderRenderer
implements BlockEntityRenderer<DimensionBuilderTileEntity> {
    public static final ResourceLocation STAGES = ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)"block/dimensionstages");

    public DimensionBuilderRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(DimensionBuilderTileEntity te, float v, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        int g;
        int b;
        int r;
        int errorMode = te.getErrorMode();
        if (errorMode != 0) {
            r = 255;
            b = 0;
            g = 0;
        } else {
            b = 255;
            g = 255;
            r = 255;
        }
        IItemHandler handler = (IItemHandler)te.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, te.getBlockPos(), null);
        if (handler != null && !handler.getStackInSlot(0).isEmpty()) {
            matrixStack.pushPose();
            matrixStack.translate(0.1, 1.2, 0.1);
            matrixStack.scale(0.8f, 0.8f, 0.8f);
            RenderHelper.renderBillboardQuadBright((PoseStack)matrixStack, (MultiBufferSource)buffer, (float)0.5f, (ResourceLocation)STAGES, (RenderSettings)RenderSettings.builder().color(r, g, b).renderType(RenderType.translucent()).alpha(128).build());
            matrixStack.popPose();
        }
    }

    public static void register() {
        BlockEntityRenderers.register(DimensionBuilderModule.TYPE_DIMENSION_BUILDER.get(), DimensionBuilderRenderer::new);
    }
}

