/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimensionbuilder.client;

import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsdim.dimension.data.ClientDimensionData;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderConfig;
import mcjty.rftoolsdim.modules.dimensionbuilder.data.PhasedFieldGeneratorData;
import mcjty.rftoolsdim.modules.dimensionbuilder.items.DimensionMonitorItem;
import mcjty.rftoolsdim.modules.dimensionbuilder.items.PhasedFieldGenerator;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ClientHelpers {
    public static String getDimensionName(ItemStack stack) {
        Level world = SafeClientTools.getClientWorld();
        if (world == null) {
            return "";
        }
        return world.dimension().location().getPath();
    }

    public static String getPowerString(ItemStack s) {
        Level world = SafeClientTools.getClientWorld();
        if (world == null) {
            return "";
        }
        ResourceLocation id = world.dimension().location();
        long power = ClientDimensionData.get().getPower(id);
        long max = ClientDimensionData.get().getMaxPower(id);
        return power == -1L ? "<n.a.>" : power + " (" + max + ")";
    }

    public static void initOverrides(DimensionMonitorItem item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)"power"), (stack, world, livingEntity, seed) -> {
            ClientLevel w = world;
            if (w == null) {
                if (livingEntity == null) {
                    return 0.0f;
                }
                w = livingEntity.getCommandSenderWorld();
            }
            ResourceLocation id = w.dimension().location();
            long power = ClientDimensionData.get().getPower(id);
            long max = ClientDimensionData.get().getMaxPower(id);
            if (max < 0L) {
                return 8.0f;
            }
            long level = 9L * power / max;
            if (level < 0L) {
                level = 0L;
            } else if (level > 8L) {
                level = 9L;
            }
            return 8L - level;
        });
    }

    public static void initOverrides(PhasedFieldGenerator item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)"power"), (stack, world, livingEntity, seed) -> {
            long max;
            long power = PhasedFieldGeneratorData.getEnergy(stack);
            long level = 9L * power / (max = ((Long)DimensionBuilderConfig.PHASEDFIELD_MAXENERGY.get()).longValue());
            if (level < 0L) {
                level = 0L;
            } else if (level > 8L) {
                level = 9L;
            }
            return 8L - level;
        });
    }
}

