/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimensionbuilder;

import java.util.function.Supplier;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.datagen.BaseItemModelProvider;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.datagen.Dob;
import mcjty.lib.modules.IModule;
import mcjty.rftoolsbase.modules.various.VariousModule;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderConfig;
import mcjty.rftoolsdim.modules.dimensionbuilder.blocks.DimensionBuilderTileEntity;
import mcjty.rftoolsdim.modules.dimensionbuilder.client.ClientHelpers;
import mcjty.rftoolsdim.modules.dimensionbuilder.client.DimensionBuilderRenderer;
import mcjty.rftoolsdim.modules.dimensionbuilder.client.GuiDimensionBuilder;
import mcjty.rftoolsdim.modules.dimensionbuilder.data.PhasedFieldGeneratorData;
import mcjty.rftoolsdim.modules.dimensionbuilder.data.RealizedTabData;
import mcjty.rftoolsdim.modules.dimensionbuilder.items.DimensionMonitorItem;
import mcjty.rftoolsdim.modules.dimensionbuilder.items.EmptyDimensionTab;
import mcjty.rftoolsdim.modules.dimensionbuilder.items.PhasedFieldGenerator;
import mcjty.rftoolsdim.modules.dimensionbuilder.items.RealizedDimensionTab;
import mcjty.rftoolsdim.setup.Config;
import mcjty.rftoolsdim.setup.Registration;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public class DimensionBuilderModule
implements IModule {
    public static final RBlock<BaseBlock, BlockItem, DimensionBuilderTileEntity> DIMENSION_BUILDER = Registration.RBLOCKS.registerBlock("dimension_builder", DimensionBuilderTileEntity.class, DimensionBuilderTileEntity::createBlock, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), DimensionBuilderTileEntity::new);
    public static final Supplier<BlockEntityType<DimensionBuilderTileEntity>> TYPE_DIMENSION_BUILDER = DIMENSION_BUILDER.be();
    public static final Supplier<MenuType<GenericContainer>> CONTAINER_DIMENSION_BUILDER = Registration.CONTAINERS.register("dimension_builder", GenericContainer::createContainerType);
    public static final DeferredItem<EmptyDimensionTab> EMPTY_DIMENSION_TAB = Registration.ITEMS.register("empty_dimension_tab", RFToolsDim.tab(EmptyDimensionTab::new));
    public static final DeferredItem<RealizedDimensionTab> REALIZED_DIMENSION_TAB = Registration.ITEMS.register("realized_dimension_tab", RFToolsDim.tab(RealizedDimensionTab::new));
    public static final DeferredItem<DimensionMonitorItem> DIMENSION_MONITOR = Registration.ITEMS.register("dimension_monitor", RFToolsDim.tab(DimensionMonitorItem::new));
    public static final DeferredItem<PhasedFieldGenerator> PHASED_FIELD_GENERATOR = Registration.ITEMS.register("phased_field_generator", RFToolsDim.tab(PhasedFieldGenerator::new));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<RealizedTabData>> ITEM_REALIZED_TAB_DATA = Registration.COMPONENTS.registerComponentType("realized_tab_data", builder -> builder.persistent(RealizedTabData.CODEC).networkSynchronized(RealizedTabData.STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<PhasedFieldGeneratorData>> ITEM_PHASED_FIELD_GENERATOR_DATA = Registration.COMPONENTS.registerComponentType("phased_field_generator_data", builder -> builder.persistent(PhasedFieldGeneratorData.CODEC).networkSynchronized(PhasedFieldGeneratorData.STREAM_CODEC));

    public DimensionBuilderModule(IEventBus bus) {
        bus.addListener(this::registerMenuScreens);
    }

    public void init(FMLCommonSetupEvent event) {
    }

    public void initClient(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ClientHelpers.initOverrides((DimensionMonitorItem)((Object)((Object)DIMENSION_MONITOR.get())));
            ClientHelpers.initOverrides((PhasedFieldGenerator)((Object)((Object)PHASED_FIELD_GENERATOR.get())));
        });
        DimensionBuilderRenderer.register();
    }

    private void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register(CONTAINER_DIMENSION_BUILDER.get(), GuiDimensionBuilder::new);
    }

    public void initConfig(IEventBus bus) {
        DimensionBuilderConfig.init(Config.SERVER_BUILDER, Config.CLIENT_BUILDER);
    }

    public void initDatagen(DataGen dataGen, HolderLookup.Provider provider) {
        dataGen.add(new Dob.Builder[]{Dob.blockBuilder(DIMENSION_BUILDER).ironPickaxeTags().parentedItem("block/dimension_builder").standardLoot(new DataComponentType[0]).blockState(p -> p.orientedBlock((Block)DIMENSION_BUILDER.block().get(), p.frontBasedModel("dimension_builder", p.modLoc("block/dimensionbuilder")))).shaped(builder -> builder.define(Character.valueOf('F'), (ItemLike)VariousModule.MACHINE_FRAME.get()).define(Character.valueOf('g'), (ItemLike)Items.GOLD_INGOT).unlockedBy("frame", DataGen.has((ItemLike)((ItemLike)VariousModule.MACHINE_FRAME.get()))), new String[]{"oeo", "dFd", "ggg"}), Dob.itemBuilder(EMPTY_DIMENSION_TAB).generatedItem("item/empty_dimension_tab").shaped(builder -> builder.unlockedBy("redstone", DataGen.has((ItemLike)Items.REDSTONE)), new String[]{"prp", "rpr", "prp"}), Dob.itemBuilder(REALIZED_DIMENSION_TAB).generatedItem("item/realized_dimension_tab"), Dob.itemBuilder(DIMENSION_MONITOR).itemModel(p -> {
            ResourceLocation powerId = ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)"power");
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(DIMENSION_MONITOR.getId().getPath())).parent((ModelFile)p.getExistingFile(p.mcLoc("item/handheld")))).texture("layer0", "item/monitor/monitoritem0")).override().predicate(powerId, 0.0f).model((ModelFile)DimensionBuilderModule.createMonitorModel(p, 0)).end().override().predicate(powerId, 1.0f).model((ModelFile)DimensionBuilderModule.createMonitorModel(p, 1)).end().override().predicate(powerId, 2.0f).model((ModelFile)DimensionBuilderModule.createMonitorModel(p, 2)).end().override().predicate(powerId, 3.0f).model((ModelFile)DimensionBuilderModule.createMonitorModel(p, 3)).end().override().predicate(powerId, 4.0f).model((ModelFile)DimensionBuilderModule.createMonitorModel(p, 4)).end().override().predicate(powerId, 5.0f).model((ModelFile)DimensionBuilderModule.createMonitorModel(p, 5)).end().override().predicate(powerId, 6.0f).model((ModelFile)DimensionBuilderModule.createMonitorModel(p, 6)).end().override().predicate(powerId, 7.0f).model((ModelFile)DimensionBuilderModule.createMonitorModel(p, 7)).end().override().predicate(powerId, 8.0f).model((ModelFile)DimensionBuilderModule.createMonitorModel(p, 8)).end();
        }).shaped(builder -> builder.define(Character.valueOf('C'), (ItemLike)Blocks.COMPARATOR).define(Character.valueOf('s'), (ItemLike)VariousModule.DIMENSIONALSHARD.get()).unlockedBy("redstone", DataGen.has((ItemLike)Items.REDSTONE)), new String[]{" s ", "rCr", " s "}), Dob.itemBuilder(PHASED_FIELD_GENERATOR).itemModel(p -> {
            ResourceLocation powerId = ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)"power");
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(PHASED_FIELD_GENERATOR.getId().getPath())).parent((ModelFile)p.getExistingFile(p.mcLoc("item/handheld")))).texture("layer0", "item/pfg/phasedfieldgeneratoriteml0")).override().predicate(powerId, 0.0f).model((ModelFile)DimensionBuilderModule.createPFGModel(p, 0)).end().override().predicate(powerId, 1.0f).model((ModelFile)DimensionBuilderModule.createPFGModel(p, 1)).end().override().predicate(powerId, 2.0f).model((ModelFile)DimensionBuilderModule.createPFGModel(p, 2)).end().override().predicate(powerId, 3.0f).model((ModelFile)DimensionBuilderModule.createPFGModel(p, 3)).end().override().predicate(powerId, 4.0f).model((ModelFile)DimensionBuilderModule.createPFGModel(p, 4)).end().override().predicate(powerId, 5.0f).model((ModelFile)DimensionBuilderModule.createPFGModel(p, 5)).end().override().predicate(powerId, 6.0f).model((ModelFile)DimensionBuilderModule.createPFGModel(p, 6)).end().override().predicate(powerId, 7.0f).model((ModelFile)DimensionBuilderModule.createPFGModel(p, 7)).end().override().predicate(powerId, 8.0f).model((ModelFile)DimensionBuilderModule.createPFGModel(p, 8)).end();
        }).shaped(builder -> builder.define(Character.valueOf('C'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('s'), (ItemLike)VariousModule.DIMENSIONALSHARD.get()).unlockedBy("redstone", DataGen.has((ItemLike)Items.REDSTONE)), new String[]{"rsr", "sCs", "rsr"})});
    }

    private static ItemModelBuilder createMonitorModel(BaseItemModelProvider provider, int suffix) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)provider.getBuilder("monitoritem" + suffix)).parent((ModelFile)provider.getExistingFile(provider.mcLoc("item/handheld")))).texture("layer0", "item/monitor/monitoritem" + suffix);
    }

    private static ItemModelBuilder createPFGModel(BaseItemModelProvider provider, int suffix) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)provider.getBuilder("phasedfieldgenerator" + suffix)).parent((ModelFile)provider.getExistingFile(provider.mcLoc("item/handheld")))).texture("layer0", "item/pfg/phasedfieldgeneratoriteml" + suffix);
    }
}

