/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.blob.tools;

import java.util.Random;
import javax.annotation.Nullable;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.modules.blob.BlobModule;
import mcjty.rftoolsdim.modules.blob.entities.DimensionalBlobEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.neoforged.neoforge.event.EventHooks;

public class Spawner {
    public static void spawnOne(ServerLevel world, Player player, CompiledDescriptor compiledDescriptor, DimensionData data, Random random) {
        double distanceX = random.nextDouble() * 100.0 - 50.0;
        double distanceZ = random.nextDouble() * 100.0 - 50.0;
        while (distanceX < 22.0 && distanceZ < 22.0) {
            distanceX = random.nextDouble() * 100.0 - 50.0;
            distanceZ = random.nextDouble() * 100.0 - 50.0;
        }
        int x = (int)(player.getX() + distanceX);
        int z = (int)(player.getZ() + distanceZ);
        EntityType<DimensionalBlobEntity> type = Spawner.randomBlob(compiledDescriptor, data, random);
        BlockPos pos = Spawner.getValidSpawnablePosition(random, (LevelReader)world, x, z);
        if (pos == null) {
            return;
        }
        boolean nocollisions = world.noCollision(type.getSpawnAABB((double)x, (double)pos.getY(), (double)z));
        boolean canSpawn = true;
        if (!nocollisions || !canSpawn) {
            return;
        }
        DimensionalBlobEntity entity = (DimensionalBlobEntity)type.create((Level)world);
        entity.moveTo(x, pos.getY(), z, random.nextFloat() * 360.0f, 0.0f);
        EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)world, (DifficultyInstance)world.getCurrentDifficultyAt(entity.blockPosition()), (MobSpawnType)MobSpawnType.NATURAL, null);
        if (entity.isSpawnCancelled()) {
            return;
        }
        if (entity.checkSpawnRules((LevelAccessor)world, MobSpawnType.NATURAL) && entity.checkSpawnObstruction((LevelReader)world)) {
            entity.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.NATURAL, null);
            world.addFreshEntityWithPassengers((Entity)entity);
        }
    }

    private static EntityType<DimensionalBlobEntity> randomBlob(CompiledDescriptor compiledDescriptor, DimensionData data, Random random) {
        float perTick = compiledDescriptor != null ? (float)compiledDescriptor.getActualPowerCost() : 0.0f;
        perTick = Math.min(perTick, 50000.0f);
        float rareChance = 0.1f + perTick / 150000.0f;
        if (random.nextFloat() < rareChance) {
            if (random.nextFloat() < rareChance) {
                return BlobModule.DIMENSIONAL_BLOB_LEGENDARY.get();
            }
            return BlobModule.DIMENSIONAL_BLOB_RARE.get();
        }
        return BlobModule.DIMENSIONAL_BLOB_COMMON.get();
    }

    @Nullable
    private static BlockPos getValidSpawnablePosition(Random random, LevelReader worldIn, int x, int z) {
        int height = worldIn.getHeight(Heightmap.Types.WORLD_SURFACE, x, z);
        if (height <= 3) {
            return null;
        }
        height = random.nextInt(height - 3) + 3;
        BlockPos blockPos = new BlockPos(x, height - 1, z);
        while (!Spawner.isValidSpawnPos(worldIn, blockPos)) {
            if ((blockPos = blockPos.below()).getY() > worldIn.getMinBuildHeight() + 1) continue;
            return null;
        }
        return blockPos;
    }

    private static boolean isValidSpawnPos(LevelReader world, BlockPos pos) {
        if (!world.getBlockState(pos).isPathfindable(PathComputationType.LAND)) {
            return false;
        }
        return world.getBlockState(pos.below()).canOcclude();
    }
}

