/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.blob.entities;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.modules.blob.BlobConfig;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class DimensionalBlobEntity
extends Monster {
    private float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private final DimletRarity rarity;
    private AABB targetBox = null;
    private int tickCounter = 5;
    private static final TargetingConditions PREDICATE = TargetingConditions.forCombat();

    public DimensionalBlobEntity(EntityType<? extends Monster> type, Level worldIn, DimletRarity rarity) {
        super(type, worldIn);
        this.rarity = rarity;
        this.calculateTargetBox(this.getBoundingBox());
    }

    private static int getDefaultMaxHealth(DimletRarity rarity) {
        return switch (rarity) {
            default -> throw new MatchException(null, null);
            case DimletRarity.COMMON -> (Integer)BlobConfig.BLOB_COMMON_HEALTH.get();
            case DimletRarity.RARE -> (Integer)BlobConfig.BLOB_RARE_HEALTH.get();
            case DimletRarity.LEGENDARY -> (Integer)BlobConfig.BLOB_LEGENDARY_HEALTH.get();
            case DimletRarity.UNCOMMON -> throw new IllegalStateException("There is no uncommon blob!");
        };
    }

    private static int getDefaultMaxHealthSetup(DimletRarity rarity) {
        return switch (rarity) {
            default -> throw new MatchException(null, null);
            case DimletRarity.COMMON -> (Integer)BlobConfig.BLOB_COMMON_HEALTH.getDefault();
            case DimletRarity.RARE -> (Integer)BlobConfig.BLOB_RARE_HEALTH.getDefault();
            case DimletRarity.LEGENDARY -> (Integer)BlobConfig.BLOB_LEGENDARY_HEALTH.getDefault();
            case DimletRarity.UNCOMMON -> throw new IllegalStateException("There is no uncommon blob!");
        };
    }

    private int getRegenLevel() {
        return switch (this.rarity) {
            default -> throw new MatchException(null, null);
            case DimletRarity.COMMON -> (Integer)BlobConfig.BLOB_COMMON_REGEN.get();
            case DimletRarity.UNCOMMON -> throw new IllegalStateException("There is no uncommon blob!");
            case DimletRarity.RARE -> (Integer)BlobConfig.BLOB_RARE_REGEN.get();
            case DimletRarity.LEGENDARY -> (Integer)BlobConfig.BLOB_LEGENDARY_REGEN.get();
        };
    }

    public void aiStep() {
        DimensionData data;
        super.aiStep();
        if (!this.level().isClientSide && (data = PersistantDimensionManager.get(this.level()).getData(this.level().dimension().location())) != null && data.getEnergy() >= (Long)BlobConfig.BLOB_REGENERATION_LEVEL.get()) {
            --this.tickCounter;
            if (this.tickCounter <= 0) {
                this.tickCounter = 5;
                this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 20, this.getRegenLevel()));
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@Nonnull ServerLevelAccessor worldIn, @Nonnull DifficultyInstance difficultyIn, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        AttributeInstance attr = this.getAttributes().getInstance(Attributes.MAX_HEALTH);
        if (attr != null) {
            attr.setBaseValue((double)DimensionalBlobEntity.getDefaultMaxHealth(this.rarity));
            this.setHealth(DimensionalBlobEntity.getDefaultMaxHealth(this.rarity));
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public static AttributeSupplier.Builder registerAttributes(DimletRarity rarity) {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.MAX_HEALTH, (double)DimensionalBlobEntity.getDefaultMaxHealthSetup(rarity));
    }

    public float getScale() {
        return switch (this.rarity) {
            default -> throw new MatchException(null, null);
            case DimletRarity.COMMON, DimletRarity.UNCOMMON -> 1.5f;
            case DimletRarity.RARE -> 2.2f;
            case DimletRarity.LEGENDARY -> 4.7f;
        };
    }

    private void calculateTargetBox(AABB bb) {
        if (this.rarity != null) {
            double radius = switch (this.rarity) {
                default -> throw new MatchException(null, null);
                case DimletRarity.COMMON, DimletRarity.UNCOMMON -> 5.0;
                case DimletRarity.RARE -> 9.0;
                case DimletRarity.LEGENDARY -> 15.0;
            };
            this.targetBox = bb.inflate(radius);
        }
    }

    private void infectPlayer(Player player) {
        player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 100));
        player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100));
        switch (this.rarity) {
            case COMMON: 
            case UNCOMMON: {
                break;
            }
            case RARE: {
                player.addEffect(new MobEffectInstance(MobEffects.POISON, 100));
                break;
            }
            case LEGENDARY: {
                player.addEffect(new MobEffectInstance(MobEffects.POISON, 100));
                player.addEffect(new MobEffectInstance(MobEffects.WITHER, 100));
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
            this.prevSquishFactor = this.squishFactor;
            if (this.random.nextFloat() < 0.03f) {
                this.squishAmount = -0.5f;
            } else if (this.random.nextFloat() < 0.03f) {
                this.squishAmount = 1.0f;
            }
            this.squishAmount *= 0.6f;
        } else if ((double)this.random.nextFloat() < 0.05) {
            List players = this.level().getNearbyPlayers(PREDICATE, (LivingEntity)this, this.targetBox);
            for (Player player : players) {
                this.infectPlayer(player);
            }
        }
    }

    public DimletRarity getRarity() {
        return this.rarity;
    }
}

