/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.blob;

import java.util.function.Supplier;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.datagen.Dob;
import mcjty.lib.modules.IModule;
import mcjty.rftoolsdim.modules.blob.BlobConfig;
import mcjty.rftoolsdim.modules.blob.entities.DimensionalBlobEntity;
import mcjty.rftoolsdim.modules.dimlets.DimletModule;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.setup.Config;
import mcjty.rftoolsdim.setup.Registration;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class BlobModule
implements IModule {
    public static final Supplier<EntityType<DimensionalBlobEntity>> DIMENSIONAL_BLOB_COMMON = Registration.ENTITIES.register("dimensional_blob_common", () -> EntityType.Builder.of((type, world) -> new DimensionalBlobEntity((EntityType<? extends Monster>)type, world, DimletRarity.COMMON), (MobCategory)MobCategory.MONSTER).sized(1.0f, 1.0f).setShouldReceiveVelocityUpdates(false).build("dimensional_blob_common"));
    public static final Supplier<EntityType<DimensionalBlobEntity>> DIMENSIONAL_BLOB_RARE = Registration.ENTITIES.register("dimensional_blob_rare", () -> EntityType.Builder.of((type, world) -> new DimensionalBlobEntity((EntityType<? extends Monster>)type, world, DimletRarity.RARE), (MobCategory)MobCategory.MONSTER).sized(1.3f, 1.3f).setShouldReceiveVelocityUpdates(false).build("dimensional_blob_rare"));
    public static final Supplier<EntityType<DimensionalBlobEntity>> DIMENSIONAL_BLOB_LEGENDARY = Registration.ENTITIES.register("dimensional_blob_legendary", () -> EntityType.Builder.of((type, world) -> new DimensionalBlobEntity((EntityType<? extends Monster>)type, world, DimletRarity.LEGENDARY), (MobCategory)MobCategory.MONSTER).sized(1.8f, 1.8f).setShouldReceiveVelocityUpdates(false).build("dimensional_blob_legendary"));

    public BlobModule(IEventBus bus, Dist dist) {
        bus.addListener(this::registerEntityAttributes);
        bus.addListener(this::registerSpawnPlacements);
    }

    public void init(FMLCommonSetupEvent event) {
    }

    private void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put(DIMENSIONAL_BLOB_COMMON.get(), DimensionalBlobEntity.registerAttributes(DimletRarity.COMMON).build());
        event.put(DIMENSIONAL_BLOB_RARE.get(), DimensionalBlobEntity.registerAttributes(DimletRarity.RARE).build());
        event.put(DIMENSIONAL_BLOB_LEGENDARY.get(), DimensionalBlobEntity.registerAttributes(DimletRarity.LEGENDARY).build());
    }

    private void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register(DIMENSIONAL_BLOB_COMMON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(DIMENSIONAL_BLOB_RARE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(DIMENSIONAL_BLOB_LEGENDARY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
    }

    public void initClient(FMLClientSetupEvent event) {
    }

    public void initConfig(IEventBus bus) {
        BlobConfig.init(Config.SERVER_BUILDER, Config.COMMON_BUILDER, Config.CLIENT_BUILDER);
    }

    public void initDatagen(DataGen dataGen, HolderLookup.Provider provider) {
        dataGen.add(new Dob.Builder[]{Dob.entityBuilder(DIMENSIONAL_BLOB_COMMON).loot(p -> p.addItemDropTable(provider, DIMENSIONAL_BLOB_COMMON.get(), (ItemLike)DimletModule.COMMON_ESSENCE.get(), 3.0f, 5.0f, 0.0f, 1.0f)), Dob.entityBuilder(DIMENSIONAL_BLOB_RARE).loot(p -> p.addItemDropTable(provider, DIMENSIONAL_BLOB_RARE.get(), (ItemLike)DimletModule.RARE_ESSENCE.get(), 3.0f, 5.0f, 0.0f, 1.0f)), Dob.entityBuilder(DIMENSIONAL_BLOB_LEGENDARY).loot(p -> p.addItemDropTable(provider, DIMENSIONAL_BLOB_LEGENDARY.get(), (ItemLike)DimletModule.LEGENDARY_ESSENCE.get(), 4.0f, 6.0f, 0.0f, 1.0f))});
    }
}

