/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.tools;

import java.util.HashSet;
import java.util.Set;
import mcjty.rftoolsdim.setup.RFToolsDimMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketSyncDimensionListChanges(Set<ResourceKey<Level>> newDimensions, Set<ResourceKey<Level>> removedDimensions) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)"syncdimensionlistchanges");
    public static final CustomPacketPayload.Type<PacketSyncDimensionListChanges> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, PacketSyncDimensionListChanges> CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeVarInt(packet.newDimensions.size());
        for (ResourceKey<Level> key : packet.newDimensions) {
            buf.writeResourceLocation(key.location());
        }
        buf.writeVarInt(packet.removedDimensions.size());
        for (ResourceKey<Level> key : packet.removedDimensions) {
            buf.writeResourceLocation(key.location());
        }
    }, buf -> {
        HashSet<ResourceKey<Level>> newDimensions = new HashSet<ResourceKey<Level>>();
        HashSet<ResourceKey<Level>> removedDimensions = new HashSet<ResourceKey<Level>>();
        int newDimensionCount = buf.readVarInt();
        for (int i = 0; i < newDimensionCount; ++i) {
            ResourceLocation worldID = buf.readResourceLocation();
            newDimensions.add(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)worldID));
        }
        int removedDimensionCount = buf.readVarInt();
        for (int i = 0; i < removedDimensionCount; ++i) {
            ResourceLocation worldID = buf.readResourceLocation();
            removedDimensions.add((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)worldID));
        }
        return new PacketSyncDimensionListChanges(newDimensions, removedDimensions);
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                Set commandSuggesterLevels = player.connection.levels();
                commandSuggesterLevels.addAll(this.newDimensions);
                for (ResourceKey<Level> key : this.removedDimensions) {
                    commandSuggesterLevels.remove(key);
                }
            }
        });
    }

    public static void updateClientDimensionLists(Set<ResourceKey<Level>> newDimensions, Set<ResourceKey<Level>> removedDimensions) {
        RFToolsDimMessages.sendToAll(new PacketSyncDimensionListChanges(newDimensions, removedDimensions));
    }
}

