/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.terraintypes.generators;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import mcjty.rftoolsdim.dimension.terraintypes.RFToolsChunkGenerator;
import mcjty.rftoolsdim.tools.PerlinNoiseGenerator14;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public class RavineGenerator {
    @NotNull
    public static CompletableFuture<ChunkAccess> fillFromNoise(ChunkAccess chunkAccess, RFToolsChunkGenerator generator) {
        ChunkPos chunkpos = chunkAccess.getPos();
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        Heightmap hmOcean = chunkAccess.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap hmWorld = chunkAccess.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE_WG);
        int minBuildHeight = chunkAccess.getMinBuildHeight();
        BlockState bedrock = Blocks.BEDROCK.defaultBlockState();
        PerlinNoiseGenerator14 noise = generator.getPerlinNoise();
        BlockState defaultBlock = generator.getDefaultBlock();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int realx = chunkpos.x * 16 + x;
                int realz = chunkpos.z * 16 + z;
                int height = RavineGenerator.calculateHeight(realx, realz, noise);
                for (int y = minBuildHeight; y < height; ++y) {
                    BlockState b = y < minBuildHeight + 2 ? bedrock : defaultBlock;
                    chunkAccess.setBlockState((BlockPos)mpos.set(x, y, z), b, false);
                    hmOcean.update(x, y, z, b);
                    hmWorld.update(x, y, z, b);
                }
            }
        }
        return CompletableFuture.completedFuture(chunkAccess);
    }

    public static int getBaseHeight(int pX, int pZ, RFToolsChunkGenerator generator) {
        return RavineGenerator.calculateHeight(pX, pZ, generator.getPerlinNoise());
    }

    private static int calculateHeight(int pX, int pZ, PerlinNoiseGenerator14 noise) {
        double value = noise.getValue((double)pX / 8.0, (double)pZ / 8.0) / 14.0 + 1.0;
        if (value < 0.0) {
            value = 0.0;
        }
        value *= 3.0;
        int az = Math.abs(pZ);
        if (az > 50) {
            value = az < 100 ? (value *= 1.0 + 29.0 * (double)(az - 50) / 50.0) : (value *= 30.0);
        }
        return (int)value + 70;
    }

    @NotNull
    public static NoiseColumn getBaseColumn(int pX, int pZ, LevelHeightAccessor level, RFToolsChunkGenerator generator) {
        Object[] states = new BlockState[RavineGenerator.calculateHeight(pX, pZ, generator.getPerlinNoise()) - level.getMinBuildHeight()];
        Arrays.fill(states, generator.getDefaultBlock());
        states[0] = Blocks.BEDROCK.defaultBlockState();
        states[1] = Blocks.BEDROCK.defaultBlockState();
        return new NoiseColumn(level.getMinBuildHeight(), (BlockState[])states);
    }
}

