/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.terraintypes.generators;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import mcjty.rftoolsdim.dimension.terraintypes.RFToolsChunkGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public class MazeGenerator {
    public static CompletableFuture<ChunkAccess> fillFromNoise(ChunkAccess chunkAccess, RFToolsChunkGenerator generator) {
        int minBuildHeight;
        ChunkPos chunkpos = chunkAccess.getPos();
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        Heightmap hmOcean = chunkAccess.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap hmWorld = chunkAccess.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE_WG);
        BlockState defaultBlock = generator.getDefaultBlock();
        long seed = generator.getSeed();
        BlockState bedrock = Blocks.BEDROCK.defaultBlockState();
        for (int y = minBuildHeight = chunkAccess.getMinBuildHeight(); y < 0; ++y) {
            BlockState b = y < minBuildHeight + 2 ? bedrock : defaultBlock;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    chunkAccess.setBlockState((BlockPos)mpos.set(x, y, z), b, false);
                }
            }
        }
        for (int cy = 0; cy < 256; cy += 16) {
            int z;
            int x;
            int y;
            boolean isTopOpen = MazeGenerator.isTopOpen(chunkpos.x, cy, chunkpos.z, seed);
            boolean isBottomOpen = cy != 0 && MazeGenerator.isTopOpen(chunkpos.x, cy - 16, chunkpos.z, seed);
            boolean isEastOpen = MazeGenerator.isEastOpen(chunkpos.x, cy, chunkpos.z, seed);
            boolean isWestOpen = MazeGenerator.isEastOpen(chunkpos.x - 1, cy, chunkpos.z, seed);
            boolean isSouthOpen = MazeGenerator.isSouthOpen(chunkpos.x, cy, chunkpos.z, seed);
            boolean isNorthOpen = MazeGenerator.isSouthOpen(chunkpos.x, cy, chunkpos.z - 1, seed);
            for (y = cy; y < cy + 4; ++y) {
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        if (isBottomOpen && x >= 4 && z >= 4 && x <= 11 && z <= 11) continue;
                        chunkAccess.setBlockState((BlockPos)mpos.set(x, y, z), defaultBlock, false);
                        hmOcean.update(x, chunkAccess.getMaxBuildHeight() - 1, z, defaultBlock);
                        hmWorld.update(x, chunkAccess.getMaxBuildHeight() - 1, z, defaultBlock);
                    }
                }
            }
            for (y = cy + 4; y < cy + 11; ++y) {
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        if (x < 4) {
                            if (isWestOpen && z >= 4 && z <= 11) continue;
                            chunkAccess.setBlockState((BlockPos)mpos.set(x, y, z), defaultBlock, false);
                            hmOcean.update(x, chunkAccess.getMaxBuildHeight() - 1, z, defaultBlock);
                            hmWorld.update(x, chunkAccess.getMaxBuildHeight() - 1, z, defaultBlock);
                            continue;
                        }
                        if (x > 11) {
                            if (isEastOpen && z >= 4 && z <= 11) continue;
                            chunkAccess.setBlockState((BlockPos)mpos.set(x, y, z), defaultBlock, false);
                            hmOcean.update(x, chunkAccess.getMaxBuildHeight() - 1, z, defaultBlock);
                            hmWorld.update(x, chunkAccess.getMaxBuildHeight() - 1, z, defaultBlock);
                            continue;
                        }
                        if (z < 4) {
                            if (isNorthOpen) continue;
                            chunkAccess.setBlockState((BlockPos)mpos.set(x, y, z), defaultBlock, false);
                            hmOcean.update(x, chunkAccess.getMaxBuildHeight() - 1, z, defaultBlock);
                            hmWorld.update(x, chunkAccess.getMaxBuildHeight() - 1, z, defaultBlock);
                            continue;
                        }
                        if (z <= 11 || isSouthOpen) continue;
                        chunkAccess.setBlockState((BlockPos)mpos.set(x, y, z), defaultBlock, false);
                        hmOcean.update(x, chunkAccess.getMaxBuildHeight() - 1, z, defaultBlock);
                        hmWorld.update(x, chunkAccess.getMaxBuildHeight() - 1, z, defaultBlock);
                    }
                }
            }
            for (y = cy + 11; y < cy + 16; ++y) {
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        if (isTopOpen && x >= 4 && z >= 4 && x <= 11 && z <= 11) continue;
                        chunkAccess.setBlockState((BlockPos)mpos.set(x, y, z), defaultBlock, false);
                        hmOcean.update(x, chunkAccess.getMaxBuildHeight() - 1, z, defaultBlock);
                        hmWorld.update(x, chunkAccess.getMaxBuildHeight() - 1, z, defaultBlock);
                    }
                }
            }
        }
        return CompletableFuture.completedFuture(chunkAccess);
    }

    private static boolean isTopOpen(int cx, int cy, int cz, long seed) {
        Random random = new Random((long)cx * 699891043L + (long)cy * 944690531L + (long)cz * 16670002577L ^ seed);
        random.nextFloat();
        return (double)random.nextFloat() < 0.3;
    }

    private static boolean isSouthOpen(int cx, int cy, int cz, long seed) {
        Random random = new Random((long)cx * 944690531L + (long)cy * 34324326931L + (long)cz * 31415927161L ^ seed);
        random.nextFloat();
        return (double)random.nextFloat() < 0.7;
    }

    private static boolean isEastOpen(int cx, int cy, int cz, long seed) {
        Random random = new Random((long)cx * 217185461L + (long)cy * 9899947L + (long)cz * 342432435349L ^ seed);
        random.nextFloat();
        return (double)random.nextFloat() < 0.7;
    }

    public static int getBaseHeight(int pX, int pZ, LevelHeightAccessor level) {
        return 256;
    }

    @NotNull
    public static NoiseColumn getBaseColumn(int pX, int pZ, LevelHeightAccessor level, RFToolsChunkGenerator generator) {
        Object[] states = new BlockState[MazeGenerator.getBaseHeight(pX, pZ, level) - level.getMinBuildHeight()];
        Arrays.fill(states, generator.getDefaultBlock());
        states[0] = Blocks.BEDROCK.defaultBlockState();
        states[1] = Blocks.BEDROCK.defaultBlockState();
        return new NoiseColumn(level.getMinBuildHeight(), (BlockState[])states);
    }
}

