/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.terraintypes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mcjty.rftoolsdim.compat.LostCityCompat;
import mcjty.rftoolsdim.dimension.data.DimensionSettings;
import mcjty.rftoolsdim.dimension.noisesettings.NoiseSamplingSettingsBuilder;
import mcjty.rftoolsdim.dimension.noisesettings.NoiseSettingsBuilder;
import mcjty.rftoolsdim.dimension.noisesettings.NoiseSliderBuilder;
import mcjty.rftoolsdim.dimension.terraintypes.AttributeType;
import mcjty.rftoolsdim.dimension.terraintypes.TerrainType;
import mcjty.rftoolsdim.dimension.terraintypes.generators.FlatGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.generators.GridGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.generators.MazeGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.generators.PlatformsGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.generators.RavineGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.generators.SpikesGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.generators.WavesGenerator;
import mcjty.rftoolsdim.tools.PerlinNoiseGenerator14;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;

public class RFToolsChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final MapCodec<RFToolsChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)StructureSet.CODEC).fieldOf("structures").forGetter(ins -> ins.overrideStructures), (App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(ins -> ins.biomeSource), (App)Codec.LONG.fieldOf("seed").stable().forGetter(RFToolsChunkGenerator::getSeed), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(NoiseBasedChunkGenerator::generatorSettings), (App)DimensionSettings.SETTINGS_CODEC.fieldOf("dimsettings").forGetter(RFToolsChunkGenerator::getDimensionSettings)).apply((Applicative)instance, instance.stable(RFToolsChunkGenerator::new)));
    private final DimensionSettings dimensionSettings;
    private final List<Holder<StructureSet>> overrideStructures;
    private final long seed;
    private PerlinNoiseGenerator14 perlinNoise = null;

    public RFToolsChunkGenerator(List<Holder<StructureSet>> overrideStructures, BiomeSource biomeSource, long seed, Holder<NoiseGeneratorSettings> settingsSupplier, DimensionSettings dimensionSettings) {
        super(biomeSource, settingsSupplier);
        this.dimensionSettings = dimensionSettings;
        this.overrideStructures = overrideStructures;
        this.seed = seed;
        this.featuresPerStep = Lazy.of(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(biomeSource.possibleBiomes()), biome -> {
            List features = ((Biome)biome.value()).getGenerationSettings().features();
            ArrayList<HolderSet.Direct> newFeatures = new ArrayList<HolderSet.Direct>();
            for (HolderSet set : features) {
                List<Holder> list = set.stream().sorted(Comparator.comparing(placedFeatureHolder -> placedFeatureHolder.unwrapKey().map(ResourceKey::toString).orElse(""))).toList();
                newFeatures.add(HolderSet.direct(list));
            }
            return newFeatures;
        }, (boolean)true));
    }

    public void changeSettings(Consumer<NoiseSettingsBuilder> noiseBuilderConsumer, Consumer<NoiseSamplingSettingsBuilder> samplingSettingsBuilderConsumer, Consumer<NoiseSliderBuilder> topSliderBuilderConsumer, Consumer<NoiseSliderBuilder> bottomSliderBuilderConsumer) {
        NoiseGeneratorSettings settings = (NoiseGeneratorSettings)this.generatorSettings().value();
    }

    public NoiseGeneratorSettings getNoiseGeneratorSettings() {
        return (NoiseGeneratorSettings)this.generatorSettings().value();
    }

    public long getSeed() {
        return this.seed;
    }

    public BlockState getDefaultBlock() {
        return ((NoiseGeneratorSettings)this.generatorSettings().value()).defaultBlock();
    }

    public PerlinNoiseGenerator14 getPerlinNoise() {
        if (this.perlinNoise == null) {
            this.perlinNoise = new PerlinNoiseGenerator14(this.seed, 4);
        }
        return this.perlinNoise;
    }

    private void checkForCities(WorldGenRegion region, TerrainType terrainType) {
        if (LostCityCompat.hasLostCities() && this.dimensionSettings.getCompiledDescriptor().getAttributeTypes().contains((Object)AttributeType.CITIES)) {
            LostCityCompat.registerDimension(region.getLevel(), (ResourceKey<Level>)region.getLevel().dimension(), LostCityCompat.getProfile(terrainType));
        }
    }

    public void buildSurface(WorldGenRegion level, StructureManager structureFeatureManager, RandomState randomState, ChunkAccess chunkAccess) {
        TerrainType terrainType = this.dimensionSettings.getCompiledDescriptor().getTerrainType();
        this.checkForCities(level, terrainType);
        if (terrainType != TerrainType.VOID && terrainType != TerrainType.FLAT) {
            super.buildSurface(level, structureFeatureManager, randomState, chunkAccess);
        }
    }

    @Nonnull
    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState randomState, StructureManager structureFeatureManager, ChunkAccess chunkAccess) {
        TerrainType terrainType = this.dimensionSettings.getCompiledDescriptor().getTerrainType();
        return switch (terrainType) {
            case TerrainType.FLAT -> FlatGenerator.fillFromNoise(chunkAccess, this);
            case TerrainType.VOID -> CompletableFuture.completedFuture(chunkAccess);
            case TerrainType.WAVES -> WavesGenerator.fillFromNoise(chunkAccess, this);
            case TerrainType.SPIKES -> SpikesGenerator.fillFromNoise(chunkAccess, this);
            case TerrainType.GRID -> GridGenerator.fillFromNoise(chunkAccess, this);
            case TerrainType.PLATFORMS -> PlatformsGenerator.fillFromNoise(chunkAccess, this);
            case TerrainType.MAZE -> MazeGenerator.fillFromNoise(chunkAccess, this);
            case TerrainType.RAVINE -> RavineGenerator.fillFromNoise(chunkAccess, this);
            default -> super.fillFromNoise(blender, randomState, structureFeatureManager, chunkAccess);
        };
    }

    public int getBaseHeight(int pX, int pZ, Heightmap.Types type, LevelHeightAccessor level, RandomState randomState) {
        TerrainType terrainType = this.dimensionSettings.getCompiledDescriptor().getTerrainType();
        return switch (terrainType) {
            case TerrainType.FLAT -> 119;
            case TerrainType.VOID -> level.getMinBuildHeight();
            case TerrainType.WAVES -> WavesGenerator.calculateWaveHeight(pX, pZ);
            case TerrainType.SPIKES -> SpikesGenerator.calculateSpikeHeight(pX, pZ, this.seed);
            case TerrainType.GRID -> GridGenerator.getBaseHeight(pX, pZ, level);
            case TerrainType.PLATFORMS -> PlatformsGenerator.getBaseHeight(pX, pZ, level, this);
            case TerrainType.MAZE -> MazeGenerator.getBaseHeight(pX, pZ, level);
            case TerrainType.RAVINE -> RavineGenerator.getBaseHeight(pX, pZ, this);
            default -> super.getBaseHeight(pX, pZ, type, level, randomState);
        };
    }

    @NotNull
    public NoiseColumn getBaseColumn(int pX, int pZ, LevelHeightAccessor level, RandomState randomState) {
        TerrainType terrainType = this.dimensionSettings.getCompiledDescriptor().getTerrainType();
        return switch (terrainType) {
            case TerrainType.FLAT -> FlatGenerator.getBaseColumn(pX, pZ, level, this);
            case TerrainType.VOID -> new NoiseColumn(level.getMinBuildHeight(), new BlockState[0]);
            case TerrainType.WAVES -> WavesGenerator.getBaseColumn(pX, pZ, level, this);
            case TerrainType.SPIKES -> SpikesGenerator.getBaseColumn(pX, pZ, level, this);
            case TerrainType.GRID -> GridGenerator.getBaseColumn(pX, pZ, level, this);
            case TerrainType.PLATFORMS -> PlatformsGenerator.getBaseColumn(pX, pZ, level, this);
            case TerrainType.MAZE -> MazeGenerator.getBaseColumn(pX, pZ, level, this);
            case TerrainType.RAVINE -> RavineGenerator.getBaseColumn(pX, pZ, level, this);
            default -> super.getBaseColumn(pX, pZ, level, randomState);
        };
    }

    public DimensionSettings getDimensionSettings() {
        return this.dimensionSettings;
    }

    @Nonnull
    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }
}

