/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.power;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsdim.dimension.DimensionConfig;
import mcjty.rftoolsdim.dimension.data.ClientDimensionData;
import mcjty.rftoolsdim.dimension.data.DimensionCreator;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.dimension.network.PackagePropageDataToClients;
import mcjty.rftoolsdim.modules.dimensionbuilder.items.PhasedFieldGenerator;
import mcjty.rftoolsdim.setup.RFToolsDimMessages;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PowerHandler {
    public static final int MAXTICKS = 10;
    private int counter = 10;
    private static final int EFFECTS_MAX = 18;
    private int counterEffects = 18;

    public static long calculateMaxDimensionPower(ResourceLocation id, Level overworld) {
        CompiledDescriptor descriptor = DimensionCreator.get().getCompiledDescriptor(overworld, id);
        if (descriptor != null) {
            return PowerHandler.calculateMaxDimensionPower(descriptor);
        }
        return (Long)DimensionConfig.MAX_DIMENSION_POWER_MAX.get();
    }

    public static long calculateMaxDimensionPower(CompiledDescriptor descriptor) {
        int cost = descriptor.getActualPowerCost();
        if (cost <= (Integer)DimensionConfig.MIN_POWER_THRESSHOLD.get()) {
            return (Long)DimensionConfig.MAX_DIMENSION_POWER_MIN.get();
        }
        if (cost >= (Integer)DimensionConfig.MAX_POWER_THRESSHOLD.get()) {
            return (Long)DimensionConfig.MAX_DIMENSION_POWER_MAX.get();
        }
        long power = (Long)DimensionConfig.MAX_DIMENSION_POWER_MIN.get() + (long)(cost - (Integer)DimensionConfig.MIN_POWER_THRESSHOLD.get()) * ((Long)DimensionConfig.MAX_DIMENSION_POWER_MAX.get() - (Long)DimensionConfig.MAX_DIMENSION_POWER_MIN.get()) / (long)((Integer)DimensionConfig.MAX_POWER_THRESSHOLD.get() - (Integer)DimensionConfig.MIN_POWER_THRESSHOLD.get());
        power /= ((Long)DimensionConfig.POWER_MULTIPLES.get()).longValue();
        return power *= ((Long)DimensionConfig.POWER_MULTIPLES.get()).longValue();
    }

    public void handlePower(Level overworld) {
        --this.counter;
        if (this.counter <= 0) {
            this.counter = 10;
            --this.counterEffects;
            boolean doEffects = false;
            if (this.counterEffects <= 0) {
                this.counterEffects = 18;
                doEffects = true;
            }
            this.handlePower(overworld, doEffects);
            this.sendOutPower(overworld);
        }
    }

    private void sendOutPower(Level overworld) {
        PersistantDimensionManager mgr = PersistantDimensionManager.get(overworld);
        HashMap<ResourceLocation, ClientDimensionData.ClientData> clientDataMap = new HashMap<ResourceLocation, ClientDimensionData.ClientData>();
        for (Map.Entry<ResourceLocation, DimensionData> entry : mgr.getData().entrySet()) {
            long energy = entry.getValue().getEnergy();
            clientDataMap.put(entry.getKey(), new ClientDimensionData.ClientData(energy, PowerHandler.calculateMaxDimensionPower(entry.getKey(), overworld), entry.getValue().getSkyTypes()));
        }
        RFToolsDimMessages.sendToAll(new PackagePropageDataToClients(clientDataMap, ((ServerLevel)overworld).getSeed()));
    }

    private void handlePower(Level overworld, boolean doEffects) {
        PersistantDimensionManager mgr = PersistantDimensionManager.get(overworld);
        for (Map.Entry<ResourceLocation, DimensionData> entry : mgr.getData().entrySet()) {
            int chunks;
            ServerLevel world = LevelTools.getLevel((Level)overworld, (ResourceLocation)entry.getKey());
            CompiledDescriptor compiledDescriptor = DimensionCreator.get().getCompiledDescriptor((Level)world);
            if (compiledDescriptor == null) continue;
            boolean doPower = true;
            if (entry.getValue().getActivityProbes() > 0 && (chunks = world.getChunkSource().chunkMap.size()) == 0) {
                doPower = false;
            }
            long power = doPower ? this.handlePowerDimension(doEffects, world, entry.getValue(), compiledDescriptor) : entry.getValue().getEnergy();
            if (doEffects && power > 0L) {
                this.handleEffectsForDimension(power, world, compiledDescriptor);
            }
            if (world == null || world.players().isEmpty()) continue;
            this.handleRandomEffects(world, entry.getValue());
        }
        mgr.save();
    }

    private long handlePowerDimension(boolean doEffects, ServerLevel world, DimensionData data, CompiledDescriptor compiledDescriptor) {
        int cost = compiledDescriptor.getActualPowerCost();
        long power = data.getEnergy();
        if ((power -= (long)cost * 10L) < 0L) {
            power = 0L;
        }
        this.handleLowPower(world, power, doEffects, cost);
        data.setEnergy((Level)world, power);
        return power;
    }

    private void handleEffectsForDimension(long power, ServerLevel world, CompiledDescriptor compiledDescriptor) {
        if (world != null) {
            ArrayList players = new ArrayList(world.players());
            for (ServerPlayer player : players) {
                long max = PowerHandler.calculateMaxDimensionPower(compiledDescriptor);
                int percentage = (int)(power * 100L / max);
                if (percentage < (Integer)DimensionConfig.DIMPOWER_WARN3.get()) {
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 360, 4, true, true));
                    player.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 360, 4, true, true));
                    player.addEffect(new MobEffectInstance(MobEffects.POISON, 360, 2, true, true));
                    player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 360, 2, true, true));
                    continue;
                }
                if (percentage < (Integer)DimensionConfig.DIMPOWER_WARN2.get()) {
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 360, 2, true, true));
                    player.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 360, 2, true, true));
                    player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 360, 1, true, true));
                    continue;
                }
                if (percentage >= (Integer)DimensionConfig.DIMPOWER_WARN1.get()) continue;
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 360, 0, true, true));
                player.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 360, 0, true, true));
            }
        }
    }

    private void handleLowPower(ServerLevel world, long power, boolean doEffects, int phasedCost) {
        if (power <= 0L && world != null) {
            ArrayList players = new ArrayList(world.players());
            for (Player player : players) {
                if (!PhasedFieldGenerator.checkValidPhasedFieldGenerator(player, true, phasedCost) || !doEffects || !((Boolean)DimensionConfig.PHASED_FIELD_GENERATOR_DEBUF.get()).booleanValue()) continue;
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 180, 2, true, true));
                player.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 180, 2, true, true));
                player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 180, 2, true, true));
            }
        }
    }

    private void handleRandomEffects(ServerLevel world, DimensionData information) {
    }
}

