/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.network;

import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolsdim.dimension.data.ClientDimensionData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PackagePropageDataToClients(Map<ResourceLocation, ClientDimensionData.ClientData> clientDataMap, long seed) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)"propagate_data_to_clients");
    public static final CustomPacketPayload.Type<PackagePropageDataToClients> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, PackagePropageDataToClients> CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeInt(packet.clientDataMap.size());
        for (Map.Entry<ResourceLocation, ClientDimensionData.ClientData> entry : packet.clientDataMap.entrySet()) {
            buf.writeResourceLocation(entry.getKey());
            entry.getValue().writeToBuf((FriendlyByteBuf)buf);
        }
        buf.writeLong(packet.seed);
    }, buf -> {
        int size = buf.readInt();
        HashMap<ResourceLocation, ClientDimensionData.ClientData> clientDataMap = new HashMap<ResourceLocation, ClientDimensionData.ClientData>(size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buf.readResourceLocation();
            clientDataMap.put(id, ClientDimensionData.ClientData.create(buf));
        }
        long seed = buf.readLong();
        return new PackagePropageDataToClients(clientDataMap, seed);
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> ClientDimensionData.get().updateDataFromServer(this.clientDataMap, this.seed));
    }
}

