/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.data;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class PersistantDimensionManager
extends AbstractWorldData<PersistantDimensionManager> {
    private static final String NAME = "RFToolsDimensions";
    private final Map<ResourceLocation, DimensionData> data = new HashMap<ResourceLocation, DimensionData>();
    private final Map<DimensionDescriptor, DimensionData> dataByDescriptor = new HashMap<DimensionDescriptor, DimensionData>();

    public PersistantDimensionManager() {
    }

    public PersistantDimensionManager(CompoundTag tag) {
        ListTag dimensions = tag.getList("dimensions", 10);
        this.data.clear();
        this.dataByDescriptor.clear();
        for (Tag inbt : dimensions) {
            CompoundTag dtag = (CompoundTag)inbt;
            DimensionData dd = new DimensionData(dtag);
            this.data.put(dd.getId(), dd);
            this.dataByDescriptor.put(dd.getDescriptor(), dd);
        }
    }

    @Nonnull
    public static PersistantDimensionManager get(Level world) {
        return (PersistantDimensionManager)PersistantDimensionManager.getData((Level)world, PersistantDimensionManager::new, PersistantDimensionManager::new, (String)NAME);
    }

    public DimensionData getData(ResourceLocation id) {
        return this.data.get(id);
    }

    public DimensionData getData(DimensionDescriptor descriptor) {
        return this.dataByDescriptor.get(descriptor);
    }

    public Map<ResourceLocation, DimensionData> getData() {
        return this.data;
    }

    public void register(DimensionData dd) {
        this.data.put(dd.getId(), dd);
        this.dataByDescriptor.put(dd.getDescriptor(), dd);
        this.setDirty();
    }

    public void forget(ResourceLocation key) {
        DimensionData dd = this.data.get(key);
        this.data.remove(key);
        if (dd != null) {
            this.dataByDescriptor.remove(dd.getDescriptor());
        }
        this.setDirty();
    }

    @Nonnull
    public CompoundTag save(@Nonnull CompoundTag compound, HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (Map.Entry<ResourceLocation, DimensionData> entry : this.data.entrySet()) {
            CompoundTag dtag = new CompoundTag();
            entry.getValue().write(dtag);
            list.add((Object)dtag);
        }
        tag.put("dimensions", (Tag)list);
        return tag;
    }
}

