/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.compat.LostCityCompat;
import mcjty.rftoolsdim.dimension.DimensionRegistry;
import mcjty.rftoolsdim.dimension.TimeType;
import mcjty.rftoolsdim.dimension.additional.SkyDimletType;
import mcjty.rftoolsdim.dimension.biomes.RFTBiomeProvider;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.DimensionSettings;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.dimension.descriptor.DescriptorError;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import mcjty.rftoolsdim.dimension.noisesettings.NoiseGeneratorSettingsBuilder;
import mcjty.rftoolsdim.dimension.terraintypes.AttributeType;
import mcjty.rftoolsdim.dimension.terraintypes.RFToolsChunkGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.TerrainType;
import mcjty.rftoolsdim.dimension.tools.DynamicDimensionManager;
import mcjty.rftoolsdim.tools.Primes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class DimensionCreator {
    private final Map<ResourceLocation, CompiledDescriptor> compiledDescriptorMap = new HashMap<ResourceLocation, CompiledDescriptor>();
    private final Map<ResourceLocation, Integer> platformHeightMap = new HashMap<ResourceLocation, Integer>();
    private final Map<String, ReservedName> reservedDimensionNames = new HashMap<String, ReservedName>();
    private static final DimensionCreator instance = new DimensionCreator();

    public static DimensionCreator get() {
        return instance;
    }

    public void clear() {
        this.platformHeightMap.clear();
        this.compiledDescriptorMap.clear();
    }

    public CompiledDescriptor getCompiledDescriptor(@Nullable Level world) {
        if (world == null) {
            return null;
        }
        ResourceKey type = world.dimension();
        ResourceLocation id = type.location();
        return this.getCompiledDescriptor(world, id);
    }

    public CompiledDescriptor getCompiledDescriptor(Level overworld, ResourceLocation id) {
        if (!this.compiledDescriptorMap.containsKey(id)) {
            ServerLevel world = LevelTools.getLevel((Level)overworld, (ResourceLocation)id);
            if (world == null) {
                return null;
            }
            ChunkGenerator generator = world.getChunkSource().getGenerator();
            if (generator instanceof RFToolsChunkGenerator) {
                RFToolsChunkGenerator rftoolsGenerator = (RFToolsChunkGenerator)generator;
                CompiledDescriptor compiledDescriptor = rftoolsGenerator.getDimensionSettings().getCompiledDescriptor();
                this.compiledDescriptorMap.put(id, compiledDescriptor);
            } else {
                RFToolsDim.setup.getLogger().error(id.toString() + " is not a dimension managed by us!");
                return null;
            }
        }
        return this.compiledDescriptorMap.get(id);
    }

    public void markReservedName(Level world, BlockPos pos, String name) {
        this.reservedDimensionNames.put(name, ReservedName.create(world, pos, System.currentTimeMillis()));
    }

    public Level getDimWorld(String name) {
        ResourceLocation id = ResourceLocation.parse((String)name);
        ResourceKey type = LevelTools.getId((ResourceLocation)id);
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().getLevel(type);
        if (world == null && !name.contains(":")) {
            id = ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)name);
            type = LevelTools.getId((ResourceLocation)id);
            return ServerLifecycleHooks.getCurrentServer().getLevel(type);
        }
        return world;
    }

    public boolean isNameAvailable(Level world, @Nullable BlockPos pos, String name) {
        long currentTime = System.currentTimeMillis();
        ReservedName reservedName = this.reservedDimensionNames.get(name);
        if (!(reservedName == null || currentTime >= reservedName.reservationTime + 10000L || reservedName.pos.equals((Object)pos) && reservedName.world.equals((Object)world.dimension()))) {
            return false;
        }
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)name);
        PersistantDimensionManager mgr = PersistantDimensionManager.get(world);
        DimensionData data = mgr.getData(id);
        return data == null;
    }

    public boolean isDescriptorAvailable(Level world, DimensionDescriptor descriptor) {
        PersistantDimensionManager mgr = PersistantDimensionManager.get(world);
        DimensionData data = mgr.getData(descriptor);
        return data == null;
    }

    public ServerLevel createWorld(ServerLevel world, String name, long seed, DimensionDescriptor descriptor, DimensionDescriptor randomizedDescriptor, UUID owner) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)name);
        PersistantDimensionManager mgr = PersistantDimensionManager.get((Level)world);
        DimensionData data = mgr.getData(id);
        if (data != null) {
            RFToolsDim.setup.getLogger().error("There is already a dimension with this id: " + name);
            throw new RuntimeException("There is already a dimension with this id: " + name);
        }
        data = mgr.getData(descriptor);
        if (data != null) {
            RFToolsDim.setup.getLogger().error("There is already a dimension with this descriptor: " + name);
            throw new RuntimeException("There is already a dimension with this descriptor: " + name);
        }
        randomizedDescriptor.log("Attempting to create dimension:");
        CompiledDescriptor compiledDescriptor = new CompiledDescriptor();
        try {
            compiledDescriptor.compile(descriptor, randomizedDescriptor);
        }
        catch (DescriptorError error) {
            RFToolsDim.setup.getLogger().error("Error compiling dimension descriptor: " + error.getMessage());
            throw new RuntimeException("Error compiling dimension descriptor: " + error.getMessage());
        }
        compiledDescriptor.complete();
        compiledDescriptor.log("Compiled Descriptor:");
        TerrainType terrainType = compiledDescriptor.getTerrainType();
        DimensionSettings settings = new DimensionSettings(seed, descriptor.compact(), randomizedDescriptor.compact());
        TimeType timeType = compiledDescriptor.getTimeType();
        ResourceKey key = LevelTools.getId((ResourceLocation)id);
        if (settings.getCompiledDescriptor().getAttributeTypes().contains((Object)AttributeType.CITIES) && LostCityCompat.hasLostCities()) {
            LostCityCompat.registerDimension(world, (ResourceKey<Level>)key, LostCityCompat.getProfile(terrainType));
        }
        RegistryAccess.Frozen registryAccess = world.getServer().registryAccess();
        ResourceLocation dimensionType = timeType.getDimensionType();
        if (terrainType == TerrainType.CAVERN) {
            dimensionType = DimensionRegistry.CAVERN_ID;
        }
        Holder.Reference type = registryAccess.registryOrThrow(Registries.DIMENSION_TYPE).getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)dimensionType));
        ServerLevel result = DynamicDimensionManager.getOrCreateLevel(world.getServer(), (ResourceKey<Level>)key, (arg_0, arg_1) -> this.lambda$createWorld$0((RegistryAccess)registryAccess, terrainType, settings, seed, (Holder)type, arg_0, arg_1));
        long skyDimletTypes = compiledDescriptor.getSkyDimletTypes();
        if (skyDimletTypes == 0L && terrainType == TerrainType.CAVERN) {
            skyDimletTypes = SkyDimletType.BLACK.getMask() | SkyDimletType.BLACKFOG.getMask();
        }
        data = new DimensionData(id, descriptor, randomizedDescriptor, owner, skyDimletTypes);
        mgr.register(data);
        return result;
    }

    public static ServerLevel getOverworld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server.getLevel(Level.OVERWORLD);
    }

    @NotNull
    private List<Holder<StructureSet>> getStructures(MinecraftServer server, DimensionSettings settings) {
        List<ResourceLocation> structures = settings.getCompiledDescriptor().getStructures();
        ArrayList<Holder<StructureSet>> list = new ArrayList<Holder<StructureSet>>();
        Primes primes = new Primes();
        for (ResourceLocation structure : structures) {
            TagKey tagKey;
            if (structure.getPath().equals("none")) {
                list.clear();
                break;
            }
            if (structure.getPath().equals("default")) {
                return Collections.emptyList();
            }
            ResourceKey registryName = Registries.STRUCTURE;
            Registry registry = DimensionCreator.getOverworld().registryAccess().registryOrThrow(registryName);
            HolderSet.Named tag = registry.getOrCreateTag(tagKey = TagKey.create((ResourceKey)registryName, (ResourceLocation)structure));
            if (tag.size() != 0) {
                tag.forEach(st -> {
                    StructureSet set = new StructureSet(st, (StructurePlacement)new RandomSpreadStructurePlacement(12, 5, RandomSpreadType.LINEAR, primes.nextIntUnsigned()));
                    list.add(Holder.direct((Object)set));
                });
            } else if (BuiltInRegistries.STRUCTURE_TYPE.containsKey(structure)) {
                server.registryAccess().registryOrThrow(Registries.STRUCTURE).getHolder(ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)structure)).ifPresent(cfg -> {
                    StructureSet set = new StructureSet((Holder)cfg, (StructurePlacement)new RandomSpreadStructurePlacement(12, 5, RandomSpreadType.LINEAR, primes.nextIntUnsigned()));
                    list.add(Holder.direct((Object)set));
                });
            }
            server.registryAccess().registryOrThrow(Registries.STRUCTURE_SET).getHolder(ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)structure)).ifPresent(list::add);
        }
        return list;
    }

    private NoiseGeneratorSettings adapt(NoiseGeneratorSettings in, DimensionSettings settings) {
        NoiseGeneratorSettingsBuilder builder = NoiseGeneratorSettingsBuilder.create(in);
        CompiledDescriptor compiledDescriptor = settings.getCompiledDescriptor();
        if (compiledDescriptor.getAttributeTypes().contains((Object)AttributeType.NOOCEANS)) {
            builder.seaLevel(-64);
        }
        if (compiledDescriptor.getAttributeTypes().contains((Object)AttributeType.WATERWORLD)) {
            builder.seaLevel(200);
        }
        if (compiledDescriptor.getTerrainType().isVoidLike()) {
            builder.seaLevel(-64);
        }
        if (compiledDescriptor.getBaseBlock() != null) {
            builder.baseBlock(compiledDescriptor.getBaseBlock());
            SurfaceRules.RuleSource adapted = this.adaptSurfaceRule(in.surfaceRule(), compiledDescriptor.getBaseBlock());
            builder.ruleSource(adapted);
        }
        builder.liquidBlock(compiledDescriptor.getBaseLiquid());
        return builder.build(settings);
    }

    private SurfaceRules.RuleSource adaptSurfaceRule(SurfaceRules.RuleSource input, BlockState baseBlock) {
        if (input instanceof SurfaceRules.BlockRuleSource) {
            return new SurfaceRules.BlockRuleSource(baseBlock);
        }
        if (input instanceof SurfaceRules.SequenceRuleSource) {
            SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)input;
            SurfaceRules.SequenceRuleSource output = new SurfaceRules.SequenceRuleSource(new ArrayList());
            for (SurfaceRules.RuleSource source : sequenceRuleSource.sequence()) {
                output.sequence().add(this.adaptSurfaceRule(source, baseBlock));
            }
            return output;
        }
        return input;
    }

    public String createDimension(ServerLevel world, String name, long seed, String filename, UUID owner) {
        ResourceKey id = LevelTools.getId((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"rftoolsdim", (String)name));
        if (world.getServer().getLevel(id) != null) {
            return "Dimension already exists!";
        }
        DimensionDescriptor descriptor = new DimensionDescriptor();
        if (!((String)filename).endsWith(".json")) {
            filename = (String)filename + ".json";
        }
        try (InputStream inputstream = RFToolsDim.class.getResourceAsStream("/data/rftoolsdim/rftdim/" + (String)filename);
             BufferedReader br = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse((Reader)br);
            descriptor.read(element.getAsJsonArray());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.createWorld(world, name, seed, descriptor, DimensionDescriptor.EMPTY, owner);
        return null;
    }

    public void registerPlatformHeight(ResourceLocation location, int floorHeight) {
        this.platformHeightMap.put(location, floorHeight);
    }

    public int getPlatformHeight(ResourceLocation location) {
        return this.platformHeightMap.getOrDefault(location, 65);
    }

    private /* synthetic */ LevelStem lambda$createWorld$0(RegistryAccess registryAccess, TerrainType terrainType, DimensionSettings settings, long seed, Holder type, MinecraftServer server, ResourceKey registryKey) {
        Registry noiseGeneratorSettings = registryAccess.registryOrThrow(Registries.NOISE_SETTINGS);
        NoiseGeneratorSettings noiseSettingsIn = (NoiseGeneratorSettings)noiseGeneratorSettings.getOrThrow(terrainType.getNoiseSettings());
        NoiseGeneratorSettings noiseSettings = this.adapt(noiseSettingsIn, settings);
        RFToolsChunkGenerator generator = new RFToolsChunkGenerator(this.getStructures(server, settings), new RFTBiomeProvider((HolderLookup.RegistryLookup<WorldPreset>)registryAccess.registryOrThrow(Registries.WORLD_PRESET).asLookup(), (HolderLookup.RegistryLookup<Biome>)registryAccess.registryOrThrow(Registries.BIOME).asLookup(), settings), seed, (Holder<NoiseGeneratorSettings>)Holder.direct((Object)noiseSettings), settings);
        return new LevelStem(type, (ChunkGenerator)generator);
    }

    private record ReservedName(long reservationTime, BlockPos pos, ResourceKey<Level> world) {
        public static ReservedName create(Level world, BlockPos pos, long reservationTime) {
            return new ReservedName(reservationTime, pos, (ResourceKey<Level>)world.dimension());
        }
    }
}

