/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.compat;

import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.compat.LostCityInternal;
import mcjty.rftoolsdim.dimension.terraintypes.TerrainType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModList;

public class LostCityCompat {
    private static boolean hasLostCities = false;
    private static boolean registered = false;
    private static LostCityInternal lostCityInternal = new LostCityInternal();

    public static void register() {
        hasLostCities = ModList.get().isLoaded("lostcities");
        if (LostCityCompat.hasLostCities()) {
            LostCityCompat.registerInternal();
        }
    }

    public static boolean hasLostCities() {
        return hasLostCities;
    }

    public static void registerDimension(ServerLevel level, ResourceKey<Level> key, String profile) {
        LostCityInternal.lostCities.registerDimension(level, key, profile);
    }

    public static String getProfile(TerrainType terrainType) {
        return switch (terrainType) {
            case TerrainType.CAVERN -> "cavern";
            default -> "default";
        };
    }

    private static void registerInternal() {
        if (registered) {
            return;
        }
        registered = true;
        Logging.log((String)"RFTools Dimensions detected LostCities: enabling support");
        InterModComms.sendTo((String)"lostcities", (String)"getLostCities", LostCityInternal.GetLostCity::new);
    }
}

