/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class CommandSetPower
implements Command<CommandSourceStack> {
    private static final CommandSetPower CMD = new CommandSetPower();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"setpower").requires(cs -> cs.hasPermission(1))).then(Commands.argument((String)"power", (ArgumentType)LongArgumentType.longArg()).executes((Command)CMD));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        SharedConstants.IS_RUNNING_IN_IDE = true;
        long power = (Long)context.getArgument("power", Long.class);
        PersistantDimensionManager mgr = PersistantDimensionManager.get((Level)((CommandSourceStack)context.getSource()).getLevel());
        DimensionData data = mgr.getData(((CommandSourceStack)context.getSource()).getLevel().dimension().location());
        if (data == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ComponentFactory.literal((String)"Not an RFTools Dimension!"));
        } else {
            data.setEnergy((Level)LevelTools.getOverworld((Level)((CommandSourceStack)context.getSource()).getLevel()), power);
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ComponentFactory.literal((String)("Power set to " + power)));
        }
        return 0;
    }
}

