/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim;

import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.modules.IModule;
import mcjty.lib.modules.Modules;
import mcjty.rftoolsdim.apiimpl.DimensionManager;
import mcjty.rftoolsdim.dimension.client.OverlayRenderer;
import mcjty.rftoolsdim.dimension.data.DimensionCreator;
import mcjty.rftoolsdim.modules.blob.BlobModule;
import mcjty.rftoolsdim.modules.decorative.DecorativeModule;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderModule;
import mcjty.rftoolsdim.modules.dimensionbuilder.items.PhasedFieldGenerator;
import mcjty.rftoolsdim.modules.dimensioneditor.DimensionEditorModule;
import mcjty.rftoolsdim.modules.dimlets.DimletModule;
import mcjty.rftoolsdim.modules.enscriber.EnscriberModule;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import mcjty.rftoolsdim.modules.knowledge.KnowledgeModule;
import mcjty.rftoolsdim.modules.various.VariousModule;
import mcjty.rftoolsdim.modules.workbench.WorkbenchModule;
import mcjty.rftoolsdim.setup.ClientSetup;
import mcjty.rftoolsdim.setup.Config;
import mcjty.rftoolsdim.setup.ModSetup;
import mcjty.rftoolsdim.setup.RFToolsDimMessages;
import mcjty.rftoolsdim.setup.Registration;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@Mod(value="rftoolsdim")
public class RFToolsDim {
    public static final String MODID = "rftoolsdim";
    public static RFToolsDim instance;
    private final Modules modules = new Modules();
    public static final ModSetup setup;

    public RFToolsDim(ModContainer mod, IEventBus bus, Dist dist) {
        instance = this;
        this.setupModules(bus, dist);
        Config.register(mod, bus, this.modules);
        Registration.register(bus);
        bus.addListener(setup::init);
        bus.addListener(arg_0 -> ((Modules)this.modules).init(arg_0));
        bus.addListener(this::processIMC);
        bus.addListener(this::onDataGen);
        bus.addListener(RFToolsDimMessages::registerMessages);
        NeoForge.EVENT_BUS.addListener(this::onJoinWorld);
        bus.addListener(setup.getBlockCapabilityRegistrar(Registration.RBLOCKS));
        bus.addListener(this::onRegisterCapabilities);
        if (dist.isClient()) {
            NeoForge.EVENT_BUS.addListener(ClientSetup::onPlayerLogin);
            NeoForge.EVENT_BUS.addListener(ClientSetup::onDimensionChange);
            NeoForge.EVENT_BUS.addListener(OverlayRenderer::render);
            bus.addListener(ClientSetup::init);
            bus.addListener(arg_0 -> ((Modules)this.modules).initClient(arg_0));
        }
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            if ("getDimensionManager".equals(message.getMethod())) {
                Supplier supplier = message.getMessageSupplier();
                ((Function)supplier.get()).apply(new DimensionManager());
            }
        });
    }

    public static <T extends Item> Supplier<T> tab(Supplier<T> supplier) {
        return setup.tab(supplier);
    }

    private void onDataGen(GatherDataEvent event) {
        DataGen datagen = new DataGen(MODID, event);
        this.modules.datagen(datagen, event.getLookupProvider());
        datagen.generate();
    }

    private void setupModules(IEventBus bus, Dist dist) {
        this.modules.register((IModule)new VariousModule());
        this.modules.register((IModule)new DimensionBuilderModule(bus));
        this.modules.register((IModule)new DimensionEditorModule(bus));
        this.modules.register((IModule)new DimletModule());
        this.modules.register((IModule)new EnscriberModule(bus));
        this.modules.register((IModule)new WorkbenchModule(bus));
        this.modules.register((IModule)new BlobModule(bus, dist));
        this.modules.register((IModule)new KnowledgeModule());
        this.modules.register((IModule)new EssencesModule());
        this.modules.register((IModule)new DecorativeModule());
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        Registration.ITEMS.getRegister().getEntries().forEach(entry -> {
            Item item = (Item)entry.get();
            if (item instanceof PhasedFieldGenerator) {
                PhasedFieldGenerator generator = (PhasedFieldGenerator)item;
                event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> generator.createEnergyStorage((ItemStack)stack), new ItemLike[]{item});
            }
        });
    }

    private void onJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        DimensionCreator.get().clear();
    }

    static {
        setup = new ModSetup();
    }
}

