/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class IngredientListCache {
    private static final IngredientListCache INSTANCE = new IngredientListCache();
    private final Object2ObjectOpenHashMap<Recipe<?>, List<List<Component>>> lists = new Object2ObjectOpenHashMap();

    private IngredientListCache() {
    }

    public List<Component> getIngredientsList(Recipe<?> recipe, Supplier<NonNullList<Ingredient>> ingredients) {
        return ((List)this.lists.computeIfAbsent(recipe, r -> IngredientListCache.createIngredientsList((NonNullList<Ingredient>)((NonNullList)ingredients.get())))).stream().map(l -> {
            long index = System.currentTimeMillis() / 2000L % (long)l.size();
            return (Component)l.get(Math.toIntExact(index));
        }).toList();
    }

    public void onResourceManagerReload(ResourceManager manager) {
        this.lists.clear();
    }

    public static IngredientListCache getInstance() {
        return INSTANCE;
    }

    private static List<List<Component>> createIngredientsList(NonNullList<Ingredient> ingredients) {
        ArrayList<ItemList> lists = new ArrayList<ItemList>();
        for (Ingredient ingredient : ingredients) {
            List<Item> items = Arrays.stream(ingredient.getItems()).map(ItemStack::getItem).toList();
            boolean matched = false;
            for (ItemList list : lists) {
                if (!list.containsAll(items)) continue;
                ++list.quantity;
                matched = true;
                break;
            }
            if (matched) continue;
            lists.add(new ItemList(items));
        }
        return lists.stream().map(s -> s.items.stream().map(i -> Component.literal((String)(s.quantity + "x ")).append(i.getDefaultInstance().getHoverName())).toList()).toList();
    }

    private static class ItemList {
        private final Set<Item> itemSet;
        public final List<Item> items;
        public int quantity;

        public ItemList(List<Item> items) {
            this.itemSet = new HashSet<Item>(items);
            this.items = items;
            this.quantity = 1;
        }

        public boolean containsAll(Collection<Item> items) {
            return this.itemSet.containsAll(items);
        }
    }
}

