/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.CachedRecipe;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.IFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.block.FluxAlternatorBlock;
import com.blakebr0.extendedcrafting.container.FluxCrafterContainer;
import com.blakebr0.extendedcrafting.crafting.TableRecipeStorage;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import com.blakebr0.extendedcrafting.tileentity.FluxAlternatorTileEntity;
import com.blakebr0.extendedcrafting.util.AlternatorParticleOffsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FluxCrafterTileEntity
extends BaseInventoryTileEntity
implements MenuProvider {
    private final BaseItemStackHandler inventory = FluxCrafterTileEntity.createInventoryHandler(this::onContentsChanged);
    private final CachedRecipe<CraftingInput, IFluxCrafterRecipe> recipe = new CachedRecipe((RecipeType)ModRecipeTypes.FLUX_CRAFTER.get());
    private int progress;
    private int progressReq;
    protected boolean isGridChanged = true;

    public FluxCrafterTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModTileEntities.FLUX_CRAFTER.get(), pos, state);
    }

    public FluxCrafterTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.progress = tag.getInt("Progress");
        this.progressReq = tag.getInt("ProgressReq");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Progress", this.progress);
        tag.putInt("ProgressReq", this.progressReq);
    }

    public Component getDisplayName() {
        return Localizable.of((String)"container.extendedcrafting.flux_crafter").build();
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return FluxCrafterContainer.create(windowId, playerInventory, this.inventory, this.getBlockPos());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FluxCrafterTileEntity tile) {
        IFluxCrafterRecipe recipe = tile.getActiveRecipe();
        CraftingInput selectedRecipe = tile.getSelectedRecipeGrid();
        if (recipe != null && (selectedRecipe == null || recipe.matches((RecipeInput)selectedRecipe, level))) {
            ItemStack output;
            ItemStack result = recipe.assemble((RecipeInput)tile.inventory.toCraftingInput(3, 3, 0, 9), (HolderLookup.Provider)level.registryAccess());
            if (StackHelper.canCombineStacks((ItemStack)result, (ItemStack)(output = tile.inventory.getStackInSlot(9)))) {
                List<FluxAlternatorTileEntity> alternators = tile.getAlternators();
                int alternatorCount = alternators.size();
                if (alternatorCount > 0) {
                    tile.progress(alternatorCount);
                    for (FluxAlternatorTileEntity alternator : alternators) {
                        Direction direction = (Direction)alternator.getBlockState().getValue((Property)FluxAlternatorBlock.FACING);
                        BlockPos alternatorPos = alternator.getBlockPos();
                        if (level.isEmptyBlock(alternatorPos.relative(direction))) {
                            tile.sendAlternatorParticles(alternatorPos, direction);
                        }
                        alternator.getEnergy().extractEnergy(recipe.getPowerRate(), false);
                    }
                    if (tile.progress >= tile.progressReq) {
                        for (int i = 0; i < tile.inventory.getSlots() - 1; ++i) {
                            tile.inventory.setStackInSlot(i, StackHelper.shrink((ItemStack)tile.inventory.getStackInSlot(i), (int)1, (boolean)false));
                        }
                        tile.updateResult(result);
                        tile.progress = 0;
                    }
                    tile.setChangedFast();
                }
            } else if (tile.progress > 0 || tile.progressReq > 0) {
                tile.reset();
                tile.setChangedFast();
            }
        } else if (tile.progress > 0 || tile.progressReq > 0) {
            tile.reset();
            tile.setChangedFast();
        }
        tile.dispatchIfChanged();
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return FluxCrafterTileEntity.createInventoryHandler(null);
    }

    public static BaseItemStackHandler createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
        return BaseItemStackHandler.create((int)10, (OnContentsChangedFunction)onContentsChanged, builder -> {
            builder.setOutputSlots(new int[]{9});
            builder.setCanInsert((slot, stack) -> false);
        });
    }

    public TableRecipeStorage getRecipeStorage() {
        return null;
    }

    private CraftingInput getSelectedRecipeGrid() {
        BaseItemStackHandler grid;
        TableRecipeStorage storage = this.getRecipeStorage();
        if (storage != null && (grid = storage.getSelectedRecipeGrid()) != null) {
            return grid.toCraftingInput(3, 3);
        }
        return null;
    }

    private void updateResult(ItemStack stack) {
        ItemStack result = this.inventory.getStackInSlot(9);
        if (result.isEmpty()) {
            this.inventory.setStackInSlot(9, stack);
        } else {
            this.inventory.setStackInSlot(9, StackHelper.grow((ItemStack)result, (int)stack.getCount()));
        }
    }

    private List<FluxAlternatorTileEntity> getAlternators() {
        ArrayList<FluxAlternatorTileEntity> alternators = new ArrayList<FluxAlternatorTileEntity>();
        Level level = this.getLevel();
        if (level != null) {
            BlockPos pos = this.getBlockPos();
            BlockPos.betweenClosedStream((BlockPos)pos.offset(-3, -3, -3), (BlockPos)pos.offset(3, 3, 3)).forEach(aoePos -> {
                FluxAlternatorTileEntity alternator;
                BlockEntity tile = level.getBlockEntity(aoePos);
                if (tile instanceof FluxAlternatorTileEntity && (alternator = (FluxAlternatorTileEntity)tile).getEnergy().getEnergyStored() >= ((IFluxCrafterRecipe)this.recipe.get()).getPowerRate()) {
                    alternators.add(alternator);
                }
            });
        }
        return alternators;
    }

    private void progress(int alternators) {
        this.progress += ((IFluxCrafterRecipe)this.recipe.get()).getPowerRate() * alternators;
        this.progressReq = ((IFluxCrafterRecipe)this.recipe.get()).getPowerRequired();
    }

    private void reset() {
        this.progress = 0;
        this.progressReq = 0;
    }

    private void sendAlternatorParticles(BlockPos pos, Direction direction) {
        if (this.getLevel() == null || this.getLevel().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.getLevel();
        AlternatorParticleOffsets offsets = AlternatorParticleOffsets.fromDirection(direction);
        double x = (double)pos.getX() + offsets.x;
        double y = (double)pos.getY() + offsets.y;
        double z = (double)pos.getZ() + offsets.z;
        level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
    }

    private void onContentsChanged(int slot) {
        if (!this.isGridChanged) {
            this.isGridChanged = true;
            this.setChanged();
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressRequired() {
        return this.progressReq;
    }

    public IFluxCrafterRecipe getActiveRecipe() {
        if (this.isGridChanged) {
            this.isGridChanged = false;
            return (IFluxCrafterRecipe)this.recipe.checkAndGet((RecipeInput)this.inventory.toCraftingInput(3, 3, 0, 9), this.level);
        }
        return (IFluxCrafterRecipe)this.recipe.get();
    }
}

