/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.energy.BaseEnergyStorage;
import com.blakebr0.cucumber.tileentity.BaseTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.FluxAlternatorContainer;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FluxAlternatorTileEntity
extends BaseTileEntity
implements MenuProvider {
    private final BaseEnergyStorage energy = new BaseEnergyStorage(((Integer)ModConfigs.FLUX_ALTERNATOR_POWER_CAPACITY.get()).intValue(), () -> ((FluxAlternatorTileEntity)this).setChangedAndDispatch());

    public FluxAlternatorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.FLUX_ALTERNATOR.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.energy.deserializeNBT(lookup, tag.get("Energy"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Energy", this.energy.getEnergyStored());
    }

    public Component getDisplayName() {
        return Localizable.of((String)"container.extendedcrafting.flux_alternator").build();
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return FluxAlternatorContainer.create(windowId, playerInventory, this.getBlockPos());
    }

    public BaseEnergyStorage getEnergy() {
        return this.energy;
    }
}

