/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.container.slot;

import com.blakebr0.extendedcrafting.api.TableCraftingInput;
import com.blakebr0.extendedcrafting.container.BasicAutoTableContainer;
import com.blakebr0.extendedcrafting.container.BasicTableContainer;
import com.blakebr0.extendedcrafting.container.inventory.ExtendedCraftingInventory;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;

public class TableOutputSlot
extends Slot {
    private final AbstractContainerMenu container;
    private final ExtendedCraftingInventory matrix;

    public TableOutputSlot(AbstractContainerMenu container, ExtendedCraftingInventory matrix, Container inventory, int index, int xPosition, int yPosition) {
        super(inventory, index, xPosition, yPosition);
        this.container = container;
        this.matrix = matrix;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public void onTake(Player player, ItemStack stack) {
        boolean isVanilla = false;
        AbstractContainerMenu abstractContainerMenu = this.container;
        if (abstractContainerMenu instanceof BasicTableContainer) {
            BasicTableContainer table = (BasicTableContainer)abstractContainerMenu;
            isVanilla = table.isVanillaRecipe();
        } else {
            abstractContainerMenu = this.container;
            if (abstractContainerMenu instanceof BasicAutoTableContainer) {
                BasicAutoTableContainer table = (BasicAutoTableContainer)abstractContainerMenu;
                isVanilla = table.isVanillaRecipe();
            }
        }
        CommonHooks.setCraftingPlayer((Player)player);
        Level level = player.level();
        TableCraftingInput inventory = this.matrix.asCraftInput();
        NonNullList remaining = isVanilla ? level.getRecipeManager().getRemainingItemsFor(RecipeType.CRAFTING, (RecipeInput)inventory, level) : level.getRecipeManager().getRemainingItemsFor((RecipeType)ModRecipeTypes.TABLE.get(), (RecipeInput)inventory, level);
        CommonHooks.setCraftingPlayer(null);
        for (int k = 0; k < inventory.height(); ++k) {
            for (int l = 0; l < inventory.width(); ++l) {
                ItemStack remainingStack;
                int index = l + inventory.left() + (k + inventory.top()) * this.matrix.getWidth();
                ItemStack slotStack = this.matrix.getItem(index);
                if (!slotStack.isEmpty()) {
                    this.matrix.removeItem(index, 1);
                    slotStack = this.matrix.getItem(index);
                }
                if ((remainingStack = (ItemStack)remaining.get(l + k * inventory.width())).isEmpty()) continue;
                if (slotStack.isEmpty()) {
                    this.matrix.setItem(index, remainingStack);
                    continue;
                }
                if (ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)remainingStack)) {
                    remainingStack.grow(slotStack.getCount());
                    this.matrix.setItem(index, remainingStack);
                    continue;
                }
                if (player.getInventory().add(remainingStack)) continue;
                player.drop(remainingStack, false);
            }
        }
        this.container.slotsChanged((Container)this.matrix);
    }
}

