/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.container.inventory;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.extendedcrafting.api.TableCraftingInput;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;

public class ExtendedCraftingInventory
extends TransientCraftingContainer {
    private final AbstractContainerMenu container;
    private final BaseItemStackHandler inventory;
    private final boolean autoTable;

    public ExtendedCraftingInventory(AbstractContainerMenu container, BaseItemStackHandler inventory, int size) {
        this(container, inventory, size, false);
    }

    public ExtendedCraftingInventory(AbstractContainerMenu container, BaseItemStackHandler inventory, int size, boolean autoTable) {
        super(container, size, size);
        this.container = container;
        this.inventory = inventory;
        this.autoTable = autoTable;
    }

    public int getContainerSize() {
        return this.autoTable ? this.inventory.getSlots() - 1 : this.inventory.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.inventory.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = this.inventory.extractItem(slot, amount, false, true);
        this.container.slotsChanged((Container)this);
        return stack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = this.inventory.getStackInSlot(slot);
        this.inventory.setStackInSlot(slot, ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.setStackInSlot(slot, stack);
        this.container.slotsChanged((Container)this);
    }

    public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public TableCraftingInput asCraftInput() {
        int tier = Math.floorDiv(this.getWidth(), 2);
        return TableCraftingInput.of(this.getWidth(), this.getHeight(), (List<ItemStack>)this.inventory.getStacks(), tier);
    }
}

