/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.extendedcrafting.api.crafting.IEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.extendedcrafting.EnderCrafting")
@ZenRegister
public final class EnderCrafting
implements IRecipeManager<IEnderCrafterRecipe> {
    public RecipeType<IEnderCrafterRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.ENDER_CRAFTER.get();
    }

    @ZenCodeType.Method
    public void addShaped(String name, IItemStack output, IIngredient[][] inputs) {
        this.addShaped(name, output, inputs, (Integer)ModConfigs.ENDER_CRAFTER_TIME_REQUIRED.get());
    }

    @ZenCodeType.Method
    public void addShaped(String name, IItemStack output, IIngredient[][] inputs, int time) {
        ResourceLocation id = CraftTweakerConstants.rl((String)this.fixRecipeName(name));
        int height = inputs.length;
        int width = 0;
        for (IIngredient[] row : inputs) {
            if (width >= row.length) continue;
            width = row.length;
        }
        NonNullList ingredients = NonNullList.withSize((int)(height * width), (Object)Ingredient.EMPTY);
        for (int a = 0; a < height; ++a) {
            for (int b = 0; b < inputs[a].length; ++b) {
                Ingredient ing = inputs[a][b].asVanillaIngredient();
                int i = a * width + b;
                ingredients.set(i, (Object)ing);
            }
        }
        ShapedRecipePattern pattern = new ShapedRecipePattern(width, height, ingredients, Optional.empty());
        ShapedEnderCrafterRecipe recipe = new ShapedEnderCrafterRecipe(pattern, output.getInternal(), time);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe)));
    }

    @ZenCodeType.Method
    public void addShapeless(String name, IItemStack output, IIngredient[] inputs) {
        this.addShapeless(name, output, inputs, (Integer)ModConfigs.ENDER_CRAFTER_TIME_REQUIRED.get());
    }

    @ZenCodeType.Method
    public void addShapeless(String name, IItemStack output, IIngredient[] inputs, int time) {
        ResourceLocation id = CraftTweakerConstants.rl((String)this.fixRecipeName(name));
        ShapelessEnderCrafterRecipe recipe = new ShapelessEnderCrafterRecipe(EnderCrafting.toIngredientsList(inputs), output.getInternal(), time);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe)));
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::create));
    }
}

