/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.extendedcrafting.api.crafting.ICombinationRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.crafting.recipe.CombinationRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.extendedcrafting.CombinationCrafting")
@ZenRegister
public final class CombinationCrafting
implements IRecipeManager<ICombinationRecipe> {
    public RecipeType<ICombinationRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.COMBINATION.get();
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack output, IIngredient input, IIngredient[] inputs, int cost) {
        this.addRecipe(name, output, input, inputs, cost, (Integer)ModConfigs.CRAFTING_CORE_POWER_RATE.get());
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack output, IIngredient input, IIngredient[] inputs, int cost, int perTick) {
        ResourceLocation id = CraftTweakerConstants.rl((String)this.fixRecipeName(name));
        CombinationRecipe recipe = new CombinationRecipe(input.asVanillaIngredient(), CombinationCrafting.toIngredientsList(inputs), output.getInternal(), cost, perTick);
        recipe.setTransformer((slot, stack) -> slot == 0 ? input.getRemainingItem((IItemStack)new MCItemStack(stack)).getInternal() : inputs[slot - 1].getRemainingItem((IItemStack)new MCItemStack(stack)).getInternal());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe)));
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::create));
    }
}

