/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.cucumber.helper.BlockHelper;
import com.blakebr0.cucumber.util.VoxelShapeBuilder;
import com.blakebr0.extendedcrafting.api.component.TableRecipeStorageComponent;
import com.blakebr0.extendedcrafting.init.ModDataComponentTypes;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BasicAutoTableBlock
extends BaseTileEntityBlock {
    public static final VoxelShape BASIC_AUTO_TABLE_SHAPE = VoxelShapeBuilder.builder().cuboid(2.0, 0.0, 2.0, 14.0, 2.0, 14.0).cuboid(3.0, 2.0, 3.0, 5.0, 10.0, 5.0).cuboid(11.0, 2.0, 11.0, 13.0, 10.0, 13.0).cuboid(11.0, 2.0, 3.0, 13.0, 10.0, 5.0).cuboid(3.0, 2.0, 11.0, 5.0, 10.0, 13.0).cuboid(0.0, 10.0, 0.0, 16.0, 16.0, 16.0).cuboid(4.0, 2.0, 4.0, 12.0, 10.0, 12.0).build();

    public BasicAutoTableBlock() {
        super(SoundType.METAL, 5.0f, 10.0f, true);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AutoTableTileEntity.Basic(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tile;
        if (!level.isClientSide() && (tile = level.getBlockEntity(pos)) instanceof AutoTableTileEntity.Basic) {
            AutoTableTileEntity.Basic table = (AutoTableTileEntity.Basic)tile;
            player.openMenu((MenuProvider)table, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (state.getBlock() != newState.getBlock() && (tile = level.getBlockEntity(pos)) instanceof AutoTableTileEntity.Basic) {
            AutoTableTileEntity.Basic table = (AutoTableTileEntity.Basic)tile;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)table.getInventory().getStacks());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockEntity tile;
        TableRecipeStorageComponent storage = (TableRecipeStorageComponent)stack.get(ModDataComponentTypes.TABLE_RECIPE_STORAGE);
        if (storage != null && (tile = level.getBlockEntity(pos)) instanceof AutoTableTileEntity.Basic) {
            AutoTableTileEntity.Basic table = (AutoTableTileEntity.Basic)tile;
            table.getRecipeStorage().deserializeNBT((HolderLookup.Provider)level.registryAccess(), storage.data());
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BASIC_AUTO_TABLE_SHAPE;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)ModTooltips.TIER.args(new Object[]{1}).build());
        TableRecipeStorageComponent storage = (TableRecipeStorageComponent)stack.get(ModDataComponentTypes.TABLE_RECIPE_STORAGE);
        if (storage != null && storage.recipeCount() > 0) {
            tooltip.add((Component)ModTooltips.RECIPE_COUNT.args(new Object[]{storage.recipeCount()}).build());
        }
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return BlockHelper.getRedstoneSignalFromInventory((BlockEntity)level.getBlockEntity(pos));
    }

    protected <T extends BlockEntity> BlockEntityTicker<T> getServerTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BasicAutoTableBlock.createTicker(type, (BlockEntityType)((BlockEntityType)ModTileEntities.BASIC_AUTO_TABLE.get()), AutoTableTileEntity::tick);
    }
}

