/*
 * Decompiled with CFR 0.152.
 */
package nl.teamdiopside.separatedleaves.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import nl.teamdiopside.separatedleaves.Reload;
import nl.teamdiopside.separatedleaves.SeparatedLeaves;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LeavesBlock.class})
public abstract class LeavesBlockMixin {
    @Shadow
    @Final
    public static IntegerProperty DISTANCE;

    @Inject(method={"updateDistance(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void updateDistance(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos, CallbackInfoReturnable<BlockState> cir) {
        ServerLevel serverLevel;
        StructureManager structureManager;
        StructureStart detectedStructure;
        if (levelAccessor instanceof ServerLevel && (detectedStructure = (structureManager = (serverLevel = (ServerLevel)levelAccessor).structureManager()).getStructureWithPieceAt(blockPos, SeparatedLeaves.ALLOW_MISMATCHED_LEAVES_STRUCTURES)).isValid()) {
            return;
        }
        ResourceLocation biome = levelAccessor.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)((Biome)levelAccessor.getBiome(blockPos).value()));
        if (biome == null || !Reload.BIOME_NAMESPACES.contains(biome.getNamespace()) || levelAccessor.getBiome(blockPos).is(SeparatedLeaves.ALLOW_MISMATCHED_LEAVES_BIOMES)) {
            return;
        }
        boolean hasFile = false;
        int i = 7;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        Block thisBlock = levelAccessor.getBlockState(blockPos).getBlock();
        for (Direction direction : Direction.values()) {
            mutableBlockPos.setWithOffset((Vec3i)blockPos, direction);
            BlockState targetState = levelAccessor.getBlockState((BlockPos)mutableBlockPos);
            Block targetBlock = targetState.getBlock();
            for (Reload.LeavesRule rule : Reload.LEAVES_RULES) {
                if (!rule.leaves().contains(thisBlock)) continue;
                hasFile = true;
                if (rule.logs().contains(targetBlock)) {
                    i = 1;
                    break;
                }
                if (!(targetBlock instanceof LeavesBlock) || !rule.leaves().contains(targetBlock)) continue;
                i = Math.min(i, (Integer)targetState.getValue((Property)DISTANCE) + 1);
            }
            if (i == 1) break;
        }
        if (hasFile) {
            cir.setReturnValue((Object)((BlockState)blockState.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i))));
        }
    }
}

