/*
 * Decompiled with CFR 0.152.
 */
package nl.teamdiopside.separatedleaves.forge;

import java.util.function.Consumer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import nl.teamdiopside.separatedleaves.Reload;
import nl.teamdiopside.separatedleaves.SeparatedLeaves;

@Mod(value="separatedleaves")
public class SeparatedLeavesForge {
    public SeparatedLeavesForge() {
        SeparatedLeaves.init();
        Consumer<TagsUpdatedEvent> tags = tagsUpdatedEvent -> {
            if (tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
                SeparatedLeavesForge.reload();
            }
        };
        Consumer<ServerStartingEvent> serverStarting = serverStartingEvent -> {
            SeparatedLeaves.minecraftServer = serverStartingEvent.getServer();
            SeparatedLeavesForge.reload();
        };
        Consumer<ServerStoppingEvent> serverStopping = serverStoppingEvent -> {
            SeparatedLeaves.minecraftServer = serverStoppingEvent.getServer();
        };
        NeoForge.EVENT_BUS.addListener(tags);
        NeoForge.EVENT_BUS.addListener(serverStarting);
        NeoForge.EVENT_BUS.addListener(serverStopping);
    }

    public static void reload() {
        if (SeparatedLeaves.minecraftServer != null) {
            Reload.reload(SeparatedLeaves.minecraftServer.getResourceManager());
        }
    }
}

