/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.growthacceleratortiers.datagen.providers.models;

import appeng.core.definitions.BlockDefinition;
import appeng.datagen.providers.models.AE2BlockStateProvider;
import dev.satherov.growthacceleratortiers.api.GAT;
import dev.satherov.growthacceleratortiers.block.GATGrowthAcceleratorBlock;
import dev.satherov.growthacceleratortiers.core.definitions.GATBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class GATBlockModelProvider
extends AE2BlockStateProvider {
    public GATBlockModelProvider(PackOutput packOutput, ExistingFileHelper exFileHelper) {
        super(packOutput, "growthacceleratortiers", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.boostedGrowthAccelerator();
        this.crankedGrowthAccelerator();
        this.monoGrowthAccelerator();
    }

    private String modelPath(BlockDefinition<?> block) {
        return block.id().getPath();
    }

    private void boostedGrowthAccelerator() {
        BlockModelBuilder unpoweredModel = (BlockModelBuilder)this.models().cubeBottomTop(this.modelPath(GATBlocks.BOOSTED_GROWTH_ACCELERATOR), GAT.rl("block/boosted/growth_accelerator_side"), GAT.rl("block/boosted/growth_accelerator_bottom"), GAT.rl("block/boosted/growth_accelerator_top"));
        BlockModelBuilder poweredModel = (BlockModelBuilder)this.models().cubeBottomTop(this.modelPath(GATBlocks.BOOSTED_GROWTH_ACCELERATOR) + "_on", GAT.rl("block/boosted/growth_accelerator_side_on"), GAT.rl("block/boosted/growth_accelerator_bottom"), GAT.rl("block/boosted/growth_accelerator_top_on"));
        this.multiVariantGenerator(GATBlocks.BOOSTED_GROWTH_ACCELERATOR, new Variant[0]).with(GATBlockModelProvider.createFacingDispatch((int)90, (int)0)).with((PropertyDispatch)PropertyDispatch.property((Property)GATGrowthAcceleratorBlock.POWERED).select((Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)unpoweredModel.getLocation())).select((Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)poweredModel.getLocation())));
        this.itemModels().withExistingParent(this.modelPath(GATBlocks.BOOSTED_GROWTH_ACCELERATOR), unpoweredModel.getLocation());
    }

    private void crankedGrowthAccelerator() {
        BlockModelBuilder unpoweredModel = (BlockModelBuilder)this.models().cubeBottomTop(this.modelPath(GATBlocks.CRANKED_GROWTH_ACCELERATOR), GAT.rl("block/cranked/growth_accelerator_side"), GAT.rl("block/cranked/growth_accelerator_bottom"), GAT.rl("block/cranked/growth_accelerator_top"));
        BlockModelBuilder poweredModel = (BlockModelBuilder)this.models().cubeBottomTop(this.modelPath(GATBlocks.CRANKED_GROWTH_ACCELERATOR) + "_on", GAT.rl("block/cranked/growth_accelerator_side_on"), GAT.rl("block/cranked/growth_accelerator_bottom"), GAT.rl("block/cranked/growth_accelerator_top_on"));
        this.multiVariantGenerator(GATBlocks.CRANKED_GROWTH_ACCELERATOR, new Variant[0]).with(GATBlockModelProvider.createFacingDispatch((int)90, (int)0)).with((PropertyDispatch)PropertyDispatch.property((Property)GATGrowthAcceleratorBlock.POWERED).select((Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)unpoweredModel.getLocation())).select((Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)poweredModel.getLocation())));
        this.itemModels().withExistingParent(this.modelPath(GATBlocks.CRANKED_GROWTH_ACCELERATOR), unpoweredModel.getLocation());
    }

    private void monoGrowthAccelerator() {
        BlockModelBuilder unpoweredModel = (BlockModelBuilder)this.models().cubeBottomTop(this.modelPath(GATBlocks.DIRECTIONAL_GROWTH_ACCELERATOR), GAT.rl("block/mono/growth_accelerator_side"), GAT.rl("block/mono/growth_accelerator_bottom"), GAT.rl("block/mono/growth_accelerator_top"));
        BlockModelBuilder poweredModel = (BlockModelBuilder)this.models().cubeBottomTop(this.modelPath(GATBlocks.DIRECTIONAL_GROWTH_ACCELERATOR) + "_on", GAT.rl("block/mono/growth_accelerator_side_on"), GAT.rl("block/mono/growth_accelerator_bottom"), GAT.rl("block/mono/growth_accelerator_top_on"));
        this.multiVariantGenerator(GATBlocks.DIRECTIONAL_GROWTH_ACCELERATOR, new Variant[0]).with(GATBlockModelProvider.createFacingDispatch((int)90, (int)0)).with((PropertyDispatch)PropertyDispatch.property((Property)GATGrowthAcceleratorBlock.POWERED).select((Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)unpoweredModel.getLocation())).select((Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)poweredModel.getLocation())));
        this.itemModels().withExistingParent(this.modelPath(GATBlocks.DIRECTIONAL_GROWTH_ACCELERATOR), unpoweredModel.getLocation());
    }
}

