/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.growthacceleratortiers.datagen;

import dev.satherov.growthacceleratortiers.datagen.providers.localization.GATLocalizationProvider;
import dev.satherov.growthacceleratortiers.datagen.providers.loot.GATLootTableProvider;
import dev.satherov.growthacceleratortiers.datagen.providers.models.GATBlockModelProvider;
import dev.satherov.growthacceleratortiers.datagen.providers.models.GATItemModelProvider;
import dev.satherov.growthacceleratortiers.datagen.providers.recipe.GATRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="growthacceleratortiers", bus=EventBusSubscriber.Bus.MOD)
public class GATDataGenerators {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        CompletableFuture registries = event.getLookupProvider();
        GATLocalizationProvider localization = new GATLocalizationProvider(generator);
        DataGenerator.PackGenerator pack = generator.getVanillaPack(true);
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        pack.addProvider(packOutput -> new GATLootTableProvider(packOutput, registries));
        pack.addProvider(packOutput -> new GATBlockModelProvider(packOutput, existingFileHelper));
        pack.addProvider(packOutput -> new GATItemModelProvider(packOutput, existingFileHelper));
        pack.addProvider(packOutput -> new GATRecipeProvider(packOutput, registries));
        pack.addProvider(packOutput -> localization);
    }
}

