/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.growthacceleratortiers.core.definitions;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.ClientTickingBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.DeferredBlockEntityType;
import com.google.common.base.Preconditions;
import dev.satherov.growthacceleratortiers.api.ids.GATBlockIds;
import dev.satherov.growthacceleratortiers.blockentity.GATBoostedBlockEntity;
import dev.satherov.growthacceleratortiers.blockentity.GATCrankedBlockEntity;
import dev.satherov.growthacceleratortiers.blockentity.GATDirectionalBlockEntity;
import dev.satherov.growthacceleratortiers.core.definitions.GATBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class GATBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> DR = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"growthacceleratortiers");
    private static final List<DeferredBlockEntityType<?>> BLOCK_ENTITY_TYPES = new ArrayList();
    public static final DeferredBlockEntityType<GATCrankedBlockEntity> CRANKED_GROWTH_ACCELERATOR = GATBlockEntities.create(GATBlockIds.CRANKED_GROWTH_ACCELERATOR.getPath(), GATCrankedBlockEntity.class, GATCrankedBlockEntity::new, GATBlocks.CRANKED_GROWTH_ACCELERATOR);
    public static final DeferredBlockEntityType<GATDirectionalBlockEntity> DIRECTIONAL_GROWTH_ACCELERATOR = GATBlockEntities.create(GATBlockIds.DIRECTIONAL_GROWTH_ACCELERATOR.getPath(), GATDirectionalBlockEntity.class, GATDirectionalBlockEntity::new, GATBlocks.DIRECTIONAL_GROWTH_ACCELERATOR);
    public static final DeferredBlockEntityType<GATBoostedBlockEntity> BOOSTED_GROWTH_ACCELERATOR = GATBlockEntities.create(GATBlockIds.BOOSTED_GROWTH_ACCELERATOR.getPath(), GATBoostedBlockEntity.class, GATBoostedBlockEntity::new, GATBlocks.BOOSTED_GROWTH_ACCELERATOR);

    public static <T extends BlockEntity> List<BlockEntityType<? extends T>> getSubclassesOf(Class<T> baseClass) {
        ArrayList<BlockEntityType<T>> result = new ArrayList<BlockEntityType<T>>();
        for (DeferredBlockEntityType<?> type : BLOCK_ENTITY_TYPES) {
            if (!baseClass.isAssignableFrom(type.getBlockEntityClass())) continue;
            result.add(type.get());
        }
        return result;
    }

    public static List<BlockEntityType<?>> getImplementorsOf(Class<?> iface) {
        ArrayList result = new ArrayList();
        for (DeferredBlockEntityType<?> type : BLOCK_ENTITY_TYPES) {
            if (!iface.isAssignableFrom(type.getBlockEntityClass())) continue;
            result.add(type.get());
        }
        return result;
    }

    @SafeVarargs
    private static <T extends AEBaseBlockEntity> DeferredBlockEntityType<T> create(String shortId, Class<T> entityClass, BlockEntityFactory<T> factory, BlockDefinition<? extends AEBaseEntityBlock<?>> ... blockDefinitions) {
        Preconditions.checkArgument((blockDefinitions.length > 0 ? 1 : 0) != 0);
        DeferredHolder deferred = DR.register(shortId, () -> {
            AtomicReference<BlockEntityType> typeHolder = new AtomicReference<BlockEntityType>();
            BlockEntityType.BlockEntitySupplier supplier = (blockPos, blockState) -> factory.create((BlockEntityType)typeHolder.get(), blockPos, blockState);
            AEBaseEntityBlock[] blocks = (AEBaseEntityBlock[])Arrays.stream(blockDefinitions).map(BlockDefinition::block).toArray(AEBaseEntityBlock[]::new);
            BlockEntityType type = BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)supplier, (Block[])blocks).build(null);
            typeHolder.setPlain(type);
            AEBaseBlockEntity.registerBlockEntityItem((BlockEntityType)type, (Item)blockDefinitions[0].asItem());
            BlockEntityTicker serverTicker = null;
            if (ServerTickingBlockEntity.class.isAssignableFrom(entityClass)) {
                serverTicker = (level, pos, state, entity) -> ((ServerTickingBlockEntity)entity).serverTick();
            }
            BlockEntityTicker clientTicker = null;
            if (ClientTickingBlockEntity.class.isAssignableFrom(entityClass)) {
                clientTicker = (level, pos, state, entity) -> ((ClientTickingBlockEntity)entity).clientTick();
            }
            AEBaseEntityBlock[] aEBaseEntityBlockArray = blocks;
            int n = aEBaseEntityBlockArray.length;
            for (int i = 0; i < n; ++i) {
                AEBaseEntityBlock block;
                AEBaseEntityBlock baseBlock = block = aEBaseEntityBlockArray[i];
                baseBlock.setBlockEntity(entityClass, type, clientTicker, serverTicker);
            }
            return type;
        });
        DeferredBlockEntityType result = new DeferredBlockEntityType(entityClass, deferred);
        BLOCK_ENTITY_TYPES.add(result);
        return result;
    }

    @FunctionalInterface
    static interface BlockEntityFactory<T extends AEBaseBlockEntity> {
        public T create(BlockEntityType<T> var1, BlockPos var2, BlockState var3);
    }
}

