/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.growthacceleratortiers.core;

import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class GATConfig {
    private static GATConfig instance;
    private final ClientConfig client = new ClientConfig();
    private final CommonConfig common = new CommonConfig();

    private GATConfig(ModContainer container) {
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.client.spec);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.common.spec);
    }

    public static void register(ModContainer container) {
        if (!container.getModId().equals("growthacceleratortiers")) {
            throw new IllegalArgumentException();
        }
        instance = new GATConfig(container);
    }

    public static GATConfig instance() {
        return instance;
    }

    private static ModConfigSpec.BooleanValue define(ModConfigSpec.Builder builder, String name, boolean defaultValue, String comment) {
        builder.comment(comment);
        return GATConfig.define(builder, name, defaultValue);
    }

    private static ModConfigSpec.BooleanValue define(ModConfigSpec.Builder builder, String name, boolean defaultValue) {
        return builder.define(name, defaultValue);
    }

    private static ModConfigSpec.IntValue define(ModConfigSpec.Builder builder, String name, int defaultValue, String comment) {
        builder.comment(comment);
        return GATConfig.define(builder, name, defaultValue);
    }

    private static ModConfigSpec.DoubleValue define(ModConfigSpec.Builder builder, String name, double defaultValue) {
        return GATConfig.define(builder, name, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    private static ModConfigSpec.DoubleValue define(ModConfigSpec.Builder builder, String name, double defaultValue, String comment) {
        builder.comment(comment);
        return GATConfig.define(builder, name, defaultValue);
    }

    private static ModConfigSpec.DoubleValue define(ModConfigSpec.Builder builder, String name, double defaultValue, double min, double max, String comment) {
        builder.comment(comment);
        return GATConfig.define(builder, name, defaultValue, min, max);
    }

    private static ModConfigSpec.DoubleValue define(ModConfigSpec.Builder builder, String name, double defaultValue, double min, double max) {
        return builder.defineInRange(name, defaultValue, min, max);
    }

    private static ModConfigSpec.IntValue define(ModConfigSpec.Builder builder, String name, int defaultValue, int min, int max, String comment) {
        builder.comment(comment);
        return GATConfig.define(builder, name, defaultValue, min, max);
    }

    private static ModConfigSpec.IntValue define(ModConfigSpec.Builder builder, String name, int defaultValue, int min, int max) {
        return builder.defineInRange(name, defaultValue, min, max);
    }

    private static ModConfigSpec.IntValue define(ModConfigSpec.Builder builder, String name, int defaultValue) {
        return builder.defineInRange(name, defaultValue, 0, Integer.MAX_VALUE);
    }

    private static <T extends Enum<T>> ModConfigSpec.EnumValue<T> defineEnum(ModConfigSpec.Builder builder, String name, T defaultValue) {
        return builder.defineEnum(name, defaultValue);
    }

    private static <T extends Enum<T>> ModConfigSpec.EnumValue<T> defineEnum(ModConfigSpec.Builder builder, String name, T defaultValue, String comment) {
        builder.comment(comment);
        return GATConfig.defineEnum(builder, name, defaultValue);
    }

    public boolean enableConflicts() {
        return (Boolean)this.common.enableConflicts.get();
    }

    public int getBoostedInternalEnergyMultiplier() {
        return (Integer)this.common.boostedInternalEnergyMultiplier.get();
    }

    public int getBoostedIdlePowerConsumption() {
        return (Integer)this.common.boostedIdlePowerConsumption.get();
    }

    public double getBoostedSpeedMultiplier() {
        return (Double)this.common.boostedSpeedMultiplier.get();
    }

    public int getCrankedInternalEnergyMultiplier() {
        return (Integer)this.common.crankedInternalEnergyMultiplier.get();
    }

    public int getCrankedIdlePowerConsumption() {
        return (Integer)this.common.crankedIdlePowerConsumption.get();
    }

    public double getCrankedSpeedMultiplier() {
        return (Double)this.common.crankedSpeedMultiplier.get();
    }

    public int getDirectionalInternalEnergyMultiplier() {
        return (Integer)this.common.directionalInternalEnergyMultiplier.get();
    }

    public int getDirectionalIdlePowerConsumption() {
        return (Integer)this.common.directionalIdlePowerConsumption.get();
    }

    public double getDirectionalSpeedMultiplier() {
        return (Double)this.common.directionalSpeedMultiplier.get();
    }

    static class ClientConfig {
        private final ModConfigSpec spec;

        public ClientConfig() {
            ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
            this.spec = builder.build();
        }
    }

    static class CommonConfig {
        private final ModConfigSpec spec;
        public ModConfigSpec.BooleanValue enableConflicts;
        public ModConfigSpec.IntValue boostedInternalEnergyMultiplier;
        public ModConfigSpec.IntValue boostedIdlePowerConsumption;
        public ModConfigSpec.DoubleValue boostedSpeedMultiplier;
        public ModConfigSpec.IntValue crankedInternalEnergyMultiplier;
        public ModConfigSpec.IntValue crankedIdlePowerConsumption;
        public ModConfigSpec.DoubleValue crankedSpeedMultiplier;
        public ModConfigSpec.IntValue directionalInternalEnergyMultiplier;
        public ModConfigSpec.IntValue directionalIdlePowerConsumption;
        public ModConfigSpec.DoubleValue directionalSpeedMultiplier;

        public CommonConfig() {
            ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
            builder.push("general");
            this.enableConflicts = GATConfig.define(builder, "enable_conflicts", true, "If set to false, the Boosted / Directional Accelerator will not conflict with other Accelerators of the same type");
            builder.pop();
            builder.push("boosted_growth_accelerator");
            this.boostedInternalEnergyMultiplier = GATConfig.define(builder, "boosted_internal_energy_multiplier", 60, 1, Integer.MAX_VALUE, "Defines the Multiplier for the internal power inventory of the Boosted Growth Accelerator.\n 10 would imitate the normal AE2 Growth Accelerator");
            this.boostedIdlePowerConsumption = GATConfig.define(builder, "boosted_idle_power_consumption", 24, 1, Integer.MAX_VALUE, "Defines the power consumption of the Boosted Growth Accelerator consumed while running.\n 8 would imitate the normal AE2 Growth Accelerator");
            this.boostedSpeedMultiplier = GATConfig.define(builder, "boosted_speed_multiplier", 8.0, 1.0, Double.MAX_VALUE, "Defines the multiplier with which the Boosted Growth Accelerator will tick the adjacent blocks.\n 1.0f would imitate the normal AE2 Growth Accelerator");
            builder.pop();
            builder.push("cranked_growth_accelerator");
            this.crankedInternalEnergyMultiplier = GATConfig.define(builder, "cranked_internal_energy_multiplier", 20, 1, Integer.MAX_VALUE, "Defines the Multiplier for the internal power inventory of the Cranked Growth Accelerator.\n 10 would imitate the normal AE2 Growth Accelerator");
            this.crankedIdlePowerConsumption = GATConfig.define(builder, "cranked_idle_power_consumption", 8, 1, Integer.MAX_VALUE, "Defines the power consumption of the Cranked Growth Accelerator consumed while running.\n 8 would imitate the normal AE2 Growth Accelerator");
            this.crankedSpeedMultiplier = GATConfig.define(builder, "cranked_speed_multiplier", 8.0, 1.0, Double.MAX_VALUE, "Defines the multiplier with which the Cranked Growth Accelerator will tick the adjacent blocks.\n 1.0f would imitate the normal AE2 Growth Accelerator");
            builder.pop();
            builder.push("directional_growth_accelerator");
            this.directionalInternalEnergyMultiplier = GATConfig.define(builder, "directional_internal_energy_multiplier", 20, 1, Integer.MAX_VALUE, "Defines the Multiplier for the internal power inventory of the Directional Growth Accelerator.\n 10 would imitate the normal AE2 Growth Accelerator");
            this.directionalIdlePowerConsumption = GATConfig.define(builder, "directional_idle_power_consumption", 12, 1, Integer.MAX_VALUE, "Defines the power consumption of the Directional Growth Accelerator consumed while running.\n 8 would imitate the normal AE2 Growth Accelerator");
            this.directionalSpeedMultiplier = GATConfig.define(builder, "directional_speed_multiplier", 2.0, 1.0, Double.MAX_VALUE, "Defines the multiplier with which the Directional Growth Accelerator will tick the adjacent blocks.\n 1.0f would imitate the normal AE2 Growth Accelerator");
            builder.pop();
            this.spec = builder.build();
        }
    }
}

