/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.growthacceleratortiers.block;

import appeng.core.AEConfig;
import appeng.core.AppEngClient;
import appeng.util.Platform;
import dev.satherov.growthacceleratortiers.block.GATGrowthAcceleratorBlock;
import dev.satherov.growthacceleratortiers.blockentity.GATMonoBlockEntity;
import dev.satherov.growthacceleratortiers.data.PositionAttachment;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.attachment.AttachmentType;

public abstract class GATMonoBlock<T extends GATMonoBlockEntity>
extends GATGrowthAcceleratorBlock<T> {
    private final Supplier<AttachmentType<PositionAttachment>> attachmentType;
    public static final BooleanProperty CONFLICTED = BooleanProperty.create((String)"conflicted");

    public GATMonoBlock(Supplier<AttachmentType<PositionAttachment>> attachmentType) {
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CONFLICTED, (Comparable)Boolean.valueOf(false)));
        this.attachmentType = attachmentType;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CONFLICTED});
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.dataUpdate((LevelAccessor)level, pos, 1);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        this.dataUpdate((LevelAccessor)level, pos, -1);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    private void dataUpdate(LevelAccessor accessor, BlockPos pos, int count) {
        if (accessor.isClientSide()) {
            return;
        }
        for (Direction dir : Direction.values()) {
            BlockPos relative = pos.relative(dir).immutable();
            ChunkAccess chunk = accessor.getChunk(relative);
            PositionAttachment data = (PositionAttachment)chunk.getData(this.getAttachmentType());
            data.put(relative, Math.clamp((long)(data.get(relative) + count), 0, 6));
            chunk.setUnsaved(true);
        }
    }

    public Supplier<AttachmentType<PositionAttachment>> getAttachmentType() {
        return this.attachmentType;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource r) {
        if (!((Boolean)state.getValue((Property)CONFLICTED)).booleanValue()) {
            super.animateTick(state, level, pos, r);
            return;
        }
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        GATMonoBlockEntity cga = (GATMonoBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (cga != null && cga.isPowered() && AppEngClient.instance().shouldAddParticles(r)) {
            double d0 = r.nextFloat() - 0.5f;
            double d1 = r.nextFloat() - 0.5f;
            Direction up = cga.getTop();
            Direction forward = cga.getFront();
            Direction west = Platform.crossProduct((Direction)forward, (Direction)up);
            double rx = 0.5 + (double)pos.getX();
            double ry = 0.5 + (double)pos.getY();
            double rz = 0.5 + (double)pos.getZ();
            rx += (double)up.getStepX() * d0;
            ry += (double)up.getStepY() * d0;
            rz += (double)up.getStepZ() * d0;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            double dz = 0.0;
            double dx = 0.0;
            BlockPos pt = null;
            switch (r.nextInt(4)) {
                case 0: {
                    dx = 0.6;
                    dz = d1;
                    pt = new BlockPos(x + west.getStepX(), y + west.getStepY(), z + west.getStepZ());
                    break;
                }
                case 1: {
                    dx = d1;
                    dz += 0.6;
                    pt = new BlockPos(x + forward.getStepX(), y + forward.getStepY(), z + forward.getStepZ());
                    break;
                }
                case 2: {
                    dx = d1;
                    dz = -0.6;
                    pt = new BlockPos(x - forward.getStepX(), y - forward.getStepY(), z - forward.getStepZ());
                    break;
                }
                case 3: {
                    dx = -0.6;
                    dz = d1;
                    pt = new BlockPos(x - west.getStepX(), y - west.getStepY(), z - west.getStepZ());
                }
            }
            if (!level.getBlockState(pt).isAir()) {
                return;
            }
            rx += dx * (double)west.getStepX();
            ry += dx * (double)west.getStepY();
            rz += dx * (double)west.getStepZ();
            Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)DustParticleOptions.REDSTONE, rx += dz * (double)forward.getStepX(), ry += dz * (double)forward.getStepY(), rz += dz * (double)forward.getStepZ(), 0.0, 0.0, 0.0);
        }
    }
}

