/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.charfilter;

import guideme.internal.shaded.lucene.internal.hppc.CharObjectHashMap;
import guideme.internal.shaded.lucene.util.CharsRef;
import guideme.internal.shaded.lucene.util.IntsRefBuilder;
import guideme.internal.shaded.lucene.util.fst.CharSequenceOutputs;
import guideme.internal.shaded.lucene.util.fst.FST;
import guideme.internal.shaded.lucene.util.fst.FSTCompiler;
import guideme.internal.shaded.lucene.util.fst.Util;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class NormalizeCharMap {
    final FST<CharsRef> map;
    final CharObjectHashMap<FST.Arc<CharsRef>> cachedRootArcs = new CharObjectHashMap();

    private NormalizeCharMap(FST<CharsRef> map) {
        this.map = map;
        if (map != null) {
            try {
                FST.Arc scratchArc = new FST.Arc();
                FST.BytesReader fstReader = map.getBytesReader();
                map.getFirstArc(scratchArc);
                if (FST.targetHasArcs(scratchArc)) {
                    map.readFirstRealTargetArc(scratchArc.target(), scratchArc, fstReader);
                    while (true) {
                        assert (scratchArc.label() != -1);
                        this.cachedRootArcs.put((char)scratchArc.label(), new FST.Arc().copyFrom(scratchArc));
                        if (!scratchArc.isLast()) {
                            map.readNextRealArc(scratchArc, fstReader);
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public static class Builder {
        private final Map<String, String> pendingPairs = new TreeMap<String, String>();

        public void add(String match, String replacement) {
            if (match.length() == 0) {
                throw new IllegalArgumentException("cannot match the empty string");
            }
            if (this.pendingPairs.putIfAbsent(match, replacement) != null) {
                throw new IllegalArgumentException("match \"" + match + "\" was already added");
            }
        }

        public NormalizeCharMap build() {
            FST<CharsRef> map;
            try {
                CharSequenceOutputs outputs = CharSequenceOutputs.getSingleton();
                FSTCompiler<CharsRef> fstCompiler = new FSTCompiler.Builder<CharsRef>(FST.INPUT_TYPE.BYTE2, outputs).build();
                IntsRefBuilder scratch = new IntsRefBuilder();
                for (Map.Entry<String, String> ent : this.pendingPairs.entrySet()) {
                    fstCompiler.add(Util.toUTF16(ent.getKey(), scratch), new CharsRef(ent.getValue()));
                }
                map = FST.fromFSTReader(fstCompiler.compile(), fstCompiler.getFSTReader());
                this.pendingPairs.clear();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return new NormalizeCharMap(map);
        }
    }
}

