/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.lang;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.swedz.tesseract.neoforge.interfaceproxy.InterfaceProxyInstance;
import net.swedz.tesseract.neoforge.lang.LangEntry;
import net.swedz.tesseract.neoforge.lang.LangHandler;

public final class LangInstance<L>
extends Record
implements InterfaceProxyInstance<L, LangHandler> {
    private final Class<L> proxyClass;
    private final L proxy;
    private final LangHandler handler;

    public LangInstance(Class<L> proxyClass, L proxy, LangHandler handler) {
        this.proxyClass = proxyClass;
        this.proxy = proxy;
        this.handler = handler;
    }

    public L lang() {
        return this.proxy;
    }

    public LangInstance<L> load() {
        InterfaceProxyInstance.super.load();
        return this;
    }

    private static void datagen(LangHandler handler, LanguageProvider provider) {
        for (LangEntry entry : handler.entries()) {
            if (entry instanceof LangEntry.SubSection) {
                LangEntry.SubSection subSection = (LangEntry.SubSection)entry;
                LangInstance.datagen(subSection.handler(), provider);
                continue;
            }
            if (entry instanceof LangEntry.Text) {
                LangEntry.Text text = (LangEntry.Text)entry;
                if (text.defaultText() == null) continue;
                provider.add(text.key(), text.defaultText());
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    public void datagen(LanguageProvider provider) {
        LangInstance.datagen(this.handler, provider);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LangInstance.class, "proxyClass;proxy;handler", "proxyClass", "proxy", "handler"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LangInstance.class, "proxyClass;proxy;handler", "proxyClass", "proxy", "handler"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LangInstance.class, "proxyClass;proxy;handler", "proxyClass", "proxy", "handler"}, this, o);
    }

    @Override
    public Class<L> proxyClass() {
        return this.proxyClass;
    }

    @Override
    public L proxy() {
        return this.proxy;
    }

    @Override
    public LangHandler handler() {
        return this.handler;
    }
}

