/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.lang;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.MutableComponent;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.helper.NamingConventionHelper;
import net.swedz.tesseract.neoforge.interfaceproxy.InterfaceProxyHandler;
import net.swedz.tesseract.neoforge.interfaceproxy.InterfaceProxyInstance;
import net.swedz.tesseract.neoforge.lang.LangContext;
import net.swedz.tesseract.neoforge.lang.LangEntry;
import net.swedz.tesseract.neoforge.lang.LangInstance;
import net.swedz.tesseract.neoforge.lang.LangManager;
import net.swedz.tesseract.neoforge.lang.annotation.LangKey;
import net.swedz.tesseract.neoforge.lang.annotation.LangKeyPattern;
import net.swedz.tesseract.neoforge.lang.annotation.Parsed;
import net.swedz.tesseract.neoforge.lang.annotation.TextSubSection;
import net.swedz.tesseract.neoforge.lang.annotation.WithStyle;
import net.swedz.tesseract.neoforge.lang.parser.LangEntryParser;
import net.swedz.tesseract.neoforge.lang.parser.ParserProvider;
import net.swedz.tesseract.neoforge.lang.placeholder.LangEntryPlaceholder;
import net.swedz.tesseract.neoforge.lang.placeholder.Placeholder;
import net.swedz.tesseract.neoforge.lang.style.LangEntryStyle;
import net.swedz.tesseract.neoforge.lang.style.StyleProvider;

public final class LangHandler
extends InterfaceProxyHandler<LangEntry<?>> {
    private final LangManager manager;
    private String subSectionPrefix = "";
    private static final Pattern PLACEHOLDER_BLOCK_PATTERN = Pattern.compile("(\\\\<(?<escaped>[^<>]+)\\\\>)|((?<!\\\\)<(?<block>[^<>]+)(?<!\\\\)>)|(%(\\$\\d+)?[sdf])");

    public LangHandler(LangManager manager) {
        this.manager = manager;
    }

    private void setSubSectionPrefix(String subSectionPrefix) {
        Assert.notNull(subSectionPrefix);
        subSectionPrefix = subSectionPrefix.trim();
        Assert.that(!subSectionPrefix.isBlank(), "TextSubSection must be provided");
        this.subSectionPrefix = subSectionPrefix + ".";
    }

    private String createLangKey(Class<?> langClass, Method method) {
        LangKey annotation = method.getAnnotation(LangKey.class);
        Assert.notNull(annotation);
        if (!annotation.value().isEmpty()) {
            return annotation.value().replace("{}", this.manager.modId());
        }
        Object prefix = langClass.isAnnotationPresent(LangKeyPattern.class) ? langClass.getAnnotation(LangKeyPattern.class).value() : "text.{}.";
        prefix = ((String)prefix).replace("{}", this.manager.modId());
        prefix = (String)prefix + this.subSectionPrefix;
        String key = !annotation.key().isEmpty() ? annotation.key() : NamingConventionHelper.fromCamelCaseToSnakeCase(method);
        return (String)prefix + key;
    }

    private StyleProvider getStyle(WithStyle annotationStyle) {
        return annotationStyle != null ? this.manager.getStyle(annotationStyle.value()) : this.manager.getStyle("default");
    }

    private LangEntryParser[] getParsers(Method method) {
        LangEntryParser[] parsers = new LangEntryParser[method.getParameterCount()];
        for (int index = 0; index < method.getParameterCount(); ++index) {
            String parserKey;
            Parameter param = method.getParameters()[index];
            Class<?> paramType = param.getType();
            if (param.isAnnotationPresent(Parsed.class)) {
                Parsed annotationParsed = param.getAnnotation(Parsed.class);
                parserKey = annotationParsed.value();
            } else {
                parserKey = "default";
            }
            ParserProvider<Object> parser = this.manager.getParser(parserKey, paramType);
            if (param.isAnnotationPresent(WithStyle.class)) {
                WithStyle annotationStyle = param.getAnnotation(WithStyle.class);
                ParserProvider<?> finalParser = parser;
                parser = (context, value) -> {
                    StyleProvider style = this.getStyle(annotationStyle);
                    return finalParser.parse(context, value).copy().withStyle(style == null ? null : style.get(context));
                };
            }
            LangContext context2 = LangContext.of(param, this.manager::getStyle, this.manager::getParser);
            parsers[index] = new LangEntryParser(context2, parser);
        }
        return parsers;
    }

    private static boolean includeFallback(Class<?> proxyClass, LangKey langKey) {
        LangKeyPattern proxyAnnotation;
        if (proxyClass.isAnnotationPresent(LangKeyPattern.class) && (proxyAnnotation = proxyClass.getAnnotation(LangKeyPattern.class)).includeFallback().length > 0) {
            return proxyAnnotation.includeFallback()[0];
        }
        return langKey.includeFallback();
    }

    private static String replaceInString(String full, String insert, int start, int end) {
        return full.substring(0, start) + insert + full.substring(end);
    }

    private static Matcher rematch(String updatedText, int index) {
        Matcher matcher = PLACEHOLDER_BLOCK_PATTERN.matcher(updatedText);
        matcher.find(index);
        return matcher;
    }

    private PlaceholdersResult getPlaceholders(Method method, LangKey langKey) {
        String text;
        if (langKey.text().length == 0 || !langKey.placeholders()) {
            return new PlaceholdersResult(null, new LangEntryPlaceholder[method.getParameterCount()]);
        }
        LangContext context = LangContext.of(method, this.manager::getStyle, this.manager::getParser);
        String replacedText = text = langKey.text()[0];
        ArrayList placeholders = Lists.newArrayList();
        Matcher matcher = PLACEHOLDER_BLOCK_PATTERN.matcher(text);
        while (matcher.find()) {
            String escapedBlock = matcher.group("escaped");
            if (escapedBlock != null) {
                int startIndex = matcher.start("escaped");
                int endIndex = matcher.end("escaped");
                replacedText = LangHandler.replaceInString(replacedText, "<" + escapedBlock + ">", startIndex - 2, endIndex + 2);
                matcher = LangHandler.rematch(replacedText, startIndex - 2);
                continue;
            }
            String block = matcher.group("block");
            if (block != null) {
                Optional<Placeholder> placeholder = this.manager.getPlaceholder(block);
                if (placeholder.isEmpty()) continue;
                placeholders.add(new LangEntryPlaceholder(context, block, placeholder.get()));
                int startIndex = matcher.start("block");
                int endIndex = matcher.end("block");
                replacedText = LangHandler.replaceInString(replacedText, "%s", startIndex - 1, endIndex + 1);
                matcher = LangHandler.rematch(replacedText, startIndex - 1);
                continue;
            }
            placeholders.add(null);
        }
        return new PlaceholdersResult(replacedText, (LangEntryPlaceholder[])placeholders.toArray(LangEntryPlaceholder[]::new));
    }

    @Override
    protected Optional<LangEntry<?>> generate(Class<?> proxyClass, Object proxy, Method method) {
        String methodSignature = method.toGenericString();
        if (method.isAnnotationPresent(TextSubSection.class)) {
            TextSubSection textSubSection = method.getAnnotation(TextSubSection.class);
            String section = textSubSection.value();
            if (section.isEmpty()) {
                section = NamingConventionHelper.fromCamelCaseToSnakeCase(method);
            }
            InterfaceProxyInstance instance = this.manager.build(method.getReturnType());
            ((LangInstance)instance).handler().setSubSectionPrefix(this.subSectionPrefix + section);
            ((LangInstance)instance).load();
            return Optional.of(new LangEntry.SubSection(((LangInstance)instance).handler(), ((LangInstance)instance).lang()));
        }
        if (method.isAnnotationPresent(LangKey.class)) {
            LangKey langKey = method.getAnnotation(LangKey.class);
            if (method.getReturnType().equals(MutableComponent.class)) {
                String key = this.createLangKey(proxyClass, method);
                StyleProvider style = this.getStyle(method.getAnnotation(WithStyle.class));
                LangEntryParser[] parsers = this.getParsers(method);
                PlaceholdersResult placeholders = this.getPlaceholders(method, langKey);
                LangEntry.Text entry = new LangEntry.Text(key, placeholders.text(), LangHandler.includeFallback(proxyClass, langKey), new LangEntryStyle(LangContext.of(method, this.manager::getStyle, this.manager::getParser), style), parsers, placeholders.providers());
                return Optional.of(entry);
            }
            throw new IllegalStateException("Method %s does not return MutableComponent".formatted(methodSignature));
        }
        return Optional.empty();
    }

    private record PlaceholdersResult(String text, LangEntryPlaceholder[] providers) {
    }
}

