/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.lang;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.swedz.tesseract.neoforge.interfaceproxy.InterfaceProxyEntry;
import net.swedz.tesseract.neoforge.lang.LangHandler;
import net.swedz.tesseract.neoforge.lang.parser.LangEntryParser;
import net.swedz.tesseract.neoforge.lang.placeholder.LangEntryPlaceholder;
import net.swedz.tesseract.neoforge.lang.style.LangEntryStyle;

public interface LangEntry<R>
extends InterfaceProxyEntry<R> {

    public record Text(String key, String defaultText, boolean includeFallback, LangEntryStyle style, LangEntryParser[] parsers, LangEntryPlaceholder[] placeholders) implements LangEntry<Component>
    {
        @Override
        public MutableComponent resolve(Object[] args) {
            Object[] parsedArgs = new Object[this.placeholders.length];
            int argIndex = 0;
            for (int placeholderIndex = 0; placeholderIndex < this.placeholders.length; ++placeholderIndex) {
                LangEntryPlaceholder placeholder = this.placeholders[placeholderIndex];
                if (placeholder == null) {
                    if (args == null) continue;
                    Object arg = args[argIndex];
                    Component parsedArg = this.parsers[argIndex].parse(arg);
                    parsedArgs[placeholderIndex] = parsedArg;
                    ++argIndex;
                    continue;
                }
                parsedArgs[placeholderIndex] = placeholder.resolve();
            }
            return Component.translatableWithFallback((String)this.key, (String)(this.includeFallback ? this.defaultText : null), (Object[])parsedArgs).withStyle(this.style.get());
        }
    }

    public record SubSection(LangHandler handler, Object instance) implements LangEntry<Object>
    {
        @Override
        public Object resolve(Object[] args) {
            return this.instance;
        }
    }
}

