/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.lang;

import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.lang.parser.ParserProvider;
import net.swedz.tesseract.neoforge.lang.style.StyleProvider;

public final class LangContext {
    private final Map<Class<?>, Annotation[]> annotations;
    private final Function<String, StyleProvider> styleGetter;
    private final BiFunction<String, Class<?>, ParserProvider<?>> parserGetter;

    private LangContext(Map<Class<?>, Annotation[]> annotations, Function<String, StyleProvider> styleGetter, BiFunction<String, Class<?>, ParserProvider<?>> parserGetter) {
        this.annotations = Collections.unmodifiableMap(annotations);
        this.styleGetter = styleGetter;
        this.parserGetter = parserGetter;
    }

    public static LangContext of(AnnotatedElement element, Function<String, StyleProvider> styleGetter, BiFunction<String, Class<?>, ParserProvider<?>> parserGetter) {
        HashMap annotations = Maps.newHashMap();
        for (Annotation annotation : element.getDeclaredAnnotations()) {
            Class<? extends Annotation> type = annotation.annotationType();
            Annotation[] current = (Annotation[])annotations.get(type);
            if (current == null) {
                annotations.put(type, new Annotation[]{annotation});
                continue;
            }
            Annotation[] copy = Arrays.copyOf(current, current.length + 1);
            copy[copy.length] = annotation;
            annotations.put(type, copy);
        }
        return new LangContext(annotations, styleGetter, parserGetter);
    }

    public boolean hasAnnotation(Class<?> type) {
        return this.annotations.containsKey(type);
    }

    public <A extends Annotation> A[] getAnnotations(Class<A> type) {
        Annotation[] present = this.annotations.get(type);
        return present == null ? new Annotation[]{} : Arrays.copyOf(present, present.length);
    }

    public <A extends Annotation> A getAnnotation(Class<A> type) {
        Annotation[] present = this.getAnnotations(type);
        return (A)(present.length == 0 ? null : present[0]);
    }

    public Style style(String key) {
        return this.styleGetter.apply(key).get(this);
    }

    public Style style() {
        return this.style("default");
    }

    public <T> Component parse(String key, Class<T> type, T value) {
        ParserProvider<?> parser = this.parserGetter.apply(key, type);
        Assert.notNull(parser, "Could not find parser for key " + key + " and type " + String.valueOf(type), IllegalArgumentException::new);
        return parser.parse(this, value);
    }

    public <T> Component parse(Class<T> type, T value) {
        return this.parse("default", type, value);
    }
}

