/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.interfaceproxy;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.swedz.tesseract.neoforge.interfaceproxy.InterfaceProxyEntry;

public abstract class InterfaceProxyHandler<E extends InterfaceProxyEntry<?>>
implements InvocationHandler {
    private Map<String, E> values = Map.of();
    private static final Method METHOD_EQUALS;
    private static final Method METHOD_HASHCODE;
    private static final Method METHOD_TOSTRING;

    public Optional<Comparator<E>> sorter() {
        return Optional.empty();
    }

    protected abstract Optional<E> generate(Class<?> var1, Object var2, Method var3);

    public final List<E> entries() {
        Stream<E> stream = this.values.values().stream();
        stream = this.sorter().map(stream::sorted).orElse(stream);
        return stream.toList();
    }

    final void loadValues(Class<?> proxyClass, Object proxy) {
        HashMap values = Maps.newHashMap();
        for (Method method : proxyClass.getMethods()) {
            String methodSignature = method.toGenericString();
            this.generate(proxyClass, proxy, method).ifPresent(entry -> {
                if (values.put(methodSignature, entry) != null) {
                    throw new IllegalStateException("Method with signature %s already exists.".formatted(methodSignature));
                }
            });
        }
        this.values = Collections.unmodifiableMap(values);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.equals(METHOD_EQUALS)) {
            return proxy == args[0];
        }
        if (method.equals(METHOD_HASHCODE)) {
            return System.identityHashCode(proxy);
        }
        if (method.equals(METHOD_TOSTRING)) {
            return proxy.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(proxy));
        }
        InterfaceProxyEntry value = (InterfaceProxyEntry)this.values.get(method.toGenericString());
        if (value == null) {
            try {
                return InvocationHandler.invokeDefault(proxy, method, args);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        return value.resolve(args);
    }

    static {
        try {
            METHOD_EQUALS = Object.class.getDeclaredMethod("equals", Object.class);
            METHOD_HASHCODE = Object.class.getDeclaredMethod("hashCode", new Class[0]);
            METHOD_TOSTRING = Object.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
    }
}

