/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper.datagen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.font.SpaceProvider;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.font.FontOption;
import net.minecraft.client.gui.font.providers.BitmapProvider;
import net.minecraft.client.gui.font.providers.GlyphProviderDefinition;
import net.minecraft.client.gui.font.providers.ProviderReferenceDefinition;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.swedz.tesseract.neoforge.api.Assert;

public abstract class FontDatagenProvider
implements DataProvider {
    private final PackOutput output;
    private final ExistingFileHelper existingFileHelper;
    private final String modId;
    private final String fontName;
    private final List<GlyphProviderDefinition.Conditional> providers = Lists.newArrayList();
    private final Set<Character> bitmapCharacters = Sets.newHashSet();

    public FontDatagenProvider(PackOutput output, ExistingFileHelper existingFileHelper, String modId, String fontName) {
        this.output = output;
        this.existingFileHelper = existingFileHelper;
        this.modId = modId;
        this.fontName = fontName;
    }

    protected abstract void addProviders();

    private static int[][] bitmapToCodepointMap(List<String> characters) {
        int rows = characters.size();
        int[][] codepoints = new int[rows][];
        for (int index = 0; index < rows; ++index) {
            codepoints[index] = characters.get(index).codePoints().toArray();
        }
        return codepoints;
    }

    public void addBitmap(List<String> characters, ResourceLocation file, int height, int ascent, FontOption.Filter condition) {
        Assert.noneNull(characters, file);
        file = file.withPath(arg_0 -> FontDatagenProvider.lambda$addBitmap$0("%s.png", arg_0));
        Assert.that(this.existingFileHelper.exists(file.withPrefix("textures/"), PackType.CLIENT_RESOURCES), "Texture %s does not exist in any known resource pack".formatted(file));
        for (String characterRow : characters) {
            for (char character : characterRow.toCharArray()) {
                if (this.bitmapCharacters.add(Character.valueOf(character))) continue;
                throw new IllegalStateException("Duplicate character " + character);
            }
        }
        BitmapProvider.Definition definition = new BitmapProvider.Definition(file, height, ascent, FontDatagenProvider.bitmapToCodepointMap(characters));
        this.add((GlyphProviderDefinition)definition, condition);
    }

    public void addBitmap(List<String> characters, ResourceLocation file, int height, int ascent) {
        this.addBitmap(characters, file, height, ascent, null);
    }

    public void addBitmap(char character, ResourceLocation file, int height, int ascent, FontOption.Filter condition) {
        this.addBitmap(List.of(String.valueOf(character)), file, height, ascent, condition);
    }

    public void addBitmap(char character, ResourceLocation file, int height, int ascent) {
        this.addBitmap(character, file, height, ascent, null);
    }

    public void addBitmap(char character, ResourceLocation file, FontOption.Filter condition) {
        this.addBitmap(character, file, 7, 7, condition);
    }

    public void addBitmap(char character, ResourceLocation file) {
        this.addBitmap(character, file, null);
    }

    public void addReference(ResourceLocation id, FontOption.Filter condition) {
        this.add((GlyphProviderDefinition)new ProviderReferenceDefinition(id), condition);
    }

    public void addReference(ResourceLocation id) {
        this.add((GlyphProviderDefinition)new ProviderReferenceDefinition(id), null);
    }

    private static Map<Integer, Float> spaceToCodepointMap(Map<Character, Float> advances) {
        HashMap codepoints = Maps.newHashMap();
        for (Map.Entry<Character, Float> entry : advances.entrySet()) {
            Character character = entry.getKey();
            Float advance = entry.getValue();
            codepoints.put(String.valueOf(character).codePointAt(0), advance);
        }
        return codepoints;
    }

    public void addSpace(Map<Character, Float> advances, FontOption.Filter condition) {
        this.add((GlyphProviderDefinition)new SpaceProvider.Definition(FontDatagenProvider.spaceToCodepointMap(advances)), condition);
    }

    public void addSpace(Map<Character, Float> advances) {
        this.addSpace(advances, null);
    }

    public void add(GlyphProviderDefinition provider, FontOption.Filter condition) {
        this.providers.add(new GlyphProviderDefinition.Conditional(provider, condition == null ? FontOption.Filter.ALWAYS_PASS : condition));
    }

    public void add(GlyphProviderDefinition provider) {
        this.add(provider, null);
    }

    public CompletableFuture<?> run(CachedOutput cachedOutput) {
        this.addProviders();
        return !this.providers.isEmpty() ? this.save(cachedOutput, this.output.getOutputFolder(PackOutput.Target.RESOURCE_PACK).resolve(this.modId).resolve("font").resolve(this.fontName + ".json")) : CompletableFuture.allOf(new CompletableFuture[0]);
    }

    private CompletableFuture<?> save(CachedOutput cachedOutput, Path target) {
        FontManager.FontDefinitionFile file = new FontManager.FontDefinitionFile(Collections.unmodifiableList(this.providers));
        JsonElement json = (JsonElement)FontManager.FontDefinitionFile.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)file).getOrThrow();
        return DataProvider.saveStable((CachedOutput)cachedOutput, (JsonElement)json, (Path)target);
    }

    public String getName() {
        return "Font: " + this.fontName + " for mod: " + this.modId;
    }

    private static /* synthetic */ String lambda$addBitmap$0(String rec$, Object xva$0) {
        return "%s.png".formatted(xva$0);
    }
}

