/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.FormattedCharSequence;

public final class ComponentHelper {
    public static Component stripStyle(Component component) {
        MutableComponent mutable;
        ComponentContents componentContents = component.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            long start2 = System.nanoTime();
            Object[] args = translatable.getArgs();
            Object[] strippedArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object object;
                Object arg = args[i];
                if (arg instanceof Component) {
                    Component c = (Component)arg;
                    object = ComponentHelper.stripStyle(c);
                } else {
                    object = arg;
                }
                strippedArgs[i] = object;
            }
            mutable = Component.translatable((String)translatable.getKey(), (Object[])strippedArgs);
        } else {
            mutable = component.copy();
            mutable.setStyle(Style.EMPTY);
        }
        ArrayList siblings = Lists.newArrayList((Iterable)component.getSiblings());
        mutable.getSiblings().clear();
        for (Component sibling : siblings) {
            mutable.append(ComponentHelper.stripStyle(sibling));
        }
        return mutable;
    }

    public static FormattedCharSequence stripStyle(FormattedCharSequence charSequence) {
        return sink -> charSequence.accept((index, style, point) -> sink.accept(index, Style.EMPTY, point));
    }
}

