/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.event.treegrowth;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.neoforged.neoforge.event.level.BlockEvent;

public final class TreeGrowthEvent
extends BlockEvent {
    private static final Set<ResourceLocation> TREE_FEATURE_IDS = Set.of(ResourceLocation.withDefaultNamespace((String)"tree"), ResourceLocation.withDefaultNamespace((String)"huge_fungus"), ResourceLocation.withDefaultNamespace((String)"huge_brown_mushroom"), ResourceLocation.withDefaultNamespace((String)"huge_red_mushroom"), ResourceLocation.fromNamespaceAndPath((String)"ohthetreesyoullgrow", (String)"tree_from_nbt_v1"), ResourceLocation.fromNamespaceAndPath((String)"ohthetreesyoullgrow", (String)"tree_from_nbt_v2"), ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)"small_yellow_bioshroom"), ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)"cobalt_tree"), ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)"large_joshua_tree"), ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)"medium_joshua_tree"), ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)"small_socotra_tree"), ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)"brim_willow"), ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)"tall_brim_willow"));
    private static final Set<SpecificFeatureConfiguration> FEATURE_CONFIGURATIONS = Set.of(new SpecificFeatureConfiguration("twilightforest", "TFTreeFeatureConfig"), new SpecificFeatureConfiguration("regions_unexplored", "GiantBioshroomConfiguration"), new SpecificFeatureConfiguration("regions_unexplored", "RuTreeConfiguration"));
    private final List<BlockPos> positions = Lists.newArrayList();

    private static boolean calculateShouldPostEventFor(Feature feature, FeatureConfiguration configuration) {
        ResourceLocation featureId = BuiltInRegistries.FEATURE.getKey((Object)feature);
        if (featureId == null) {
            return false;
        }
        if (TREE_FEATURE_IDS.contains(featureId)) {
            return true;
        }
        String featureNamespace = featureId.getNamespace();
        String configurationClassName = configuration.getClass().getSimpleName();
        for (SpecificFeatureConfiguration specific : FEATURE_CONFIGURATIONS) {
            if (!featureNamespace.equals(specific.namespace()) || !configurationClassName.equals(specific.configurationClassName())) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldPostEventFor(Feature feature, FeatureConfiguration configuration) {
        if (feature.needsToCalculateShouldPostTreeGrowthEvent()) {
            boolean should = TreeGrowthEvent.calculateShouldPostEventFor(feature, configuration);
            feature.setShouldPostTreeGrowthEvent(should);
            return should;
        }
        return feature.shouldPostTreeGrowthEvent();
    }

    public TreeGrowthEvent(LevelAccessor level, BlockPos pos, BlockState state, Collection<BlockPos> positions) {
        super(level, pos.immutable(), state);
        this.positions.addAll(positions);
    }

    public List<BlockPos> getPositions() {
        return new ArrayList<BlockPos>(this.positions);
    }

    private record SpecificFeatureConfiguration(String namespace, String configurationClassName) {
    }
}

