/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.event.treegrowth;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelTickAccess;
import net.swedz.tesseract.neoforge.api.Assert;

public final class TrackingWorldGenLevel
implements WorldGenLevel {
    private final WorldGenLevel level;
    private final Consumer<BlockPos> onSetBlock;
    private final Set<BlockPos> modifiedBlocks = Sets.newConcurrentHashSet();

    public TrackingWorldGenLevel(WorldGenLevel level, Consumer<BlockPos> onSetBlock) {
        Assert.noneNull(level, onSetBlock);
        this.level = level;
        this.onSetBlock = onSetBlock;
    }

    public TrackingWorldGenLevel(WorldGenLevel level) {
        this(level, pos -> {});
    }

    public Set<BlockPos> getModifiedBlockPositions() {
        return Collections.unmodifiableSet(this.modifiedBlocks);
    }

    public long getSeed() {
        return this.level.getSeed();
    }

    public ServerLevel getLevel() {
        return this.level.getLevel();
    }

    public long nextSubTickCount() {
        return this.level.nextSubTickCount();
    }

    public LevelTickAccess<Block> getBlockTicks() {
        return this.level.getBlockTicks();
    }

    public LevelTickAccess<Fluid> getFluidTicks() {
        return this.level.getFluidTicks();
    }

    public LevelData getLevelData() {
        return this.level.getLevelData();
    }

    public DifficultyInstance getCurrentDifficultyAt(BlockPos pos) {
        return this.level.getCurrentDifficultyAt(pos);
    }

    public MinecraftServer getServer() {
        return this.level.getServer();
    }

    public ChunkSource getChunkSource() {
        return this.level.getChunkSource();
    }

    public RandomSource getRandom() {
        return this.level.getRandom();
    }

    public void playSound(Player player, BlockPos pos, SoundEvent sound, SoundSource source, float volume, float pitch) {
        this.level.playSound(player, pos, sound, source, volume, pitch);
    }

    public void addParticle(ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.level.addParticle(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void levelEvent(Player player, int type, BlockPos pos, int data) {
        this.level.levelEvent(player, type, pos, data);
    }

    public void gameEvent(Holder<GameEvent> gameEvent, Vec3 pos, GameEvent.Context context) {
        this.level.gameEvent(gameEvent, pos, context);
    }

    public float getShade(Direction direction, boolean shade) {
        return this.level.getShade(direction, shade);
    }

    public LevelLightEngine getLightEngine() {
        return this.level.getLightEngine();
    }

    public WorldBorder getWorldBorder() {
        return this.level.getWorldBorder();
    }

    public BlockEntity getBlockEntity(BlockPos pos) {
        return this.level.getBlockEntity(pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.level.getBlockState(pos);
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.level.getFluidState(pos);
    }

    public List<Entity> getEntities(Entity entity, AABB area, Predicate<? super Entity> predicate) {
        return this.level.getEntities(entity, area);
    }

    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> entityTypeTest, AABB bounds, Predicate<? super T> predicate) {
        return this.level.getEntities(entityTypeTest, bounds, predicate);
    }

    public List<? extends Player> players() {
        return this.level.players();
    }

    public ChunkAccess getChunk(int x, int z, ChunkStatus chunkStatus, boolean requireChunk) {
        return this.level.getChunk(x, z, chunkStatus, requireChunk);
    }

    public int getHeight(Heightmap.Types heightmapType, int x, int z) {
        return this.level.getHeight(heightmapType, x, z);
    }

    public int getSkyDarken() {
        return this.level.getSkyDarken();
    }

    public BiomeManager getBiomeManager() {
        return this.level.getBiomeManager();
    }

    public Holder<Biome> getUncachedNoiseBiome(int x, int y, int z) {
        return this.level.getUncachedNoiseBiome(x, y, z);
    }

    public boolean isClientSide() {
        return this.level.isClientSide();
    }

    public int getSeaLevel() {
        return this.level.getSeaLevel();
    }

    public DimensionType dimensionType() {
        return this.level.dimensionType();
    }

    public RegistryAccess registryAccess() {
        return this.level.registryAccess();
    }

    public FeatureFlagSet enabledFeatures() {
        return this.level.enabledFeatures();
    }

    public boolean isStateAtPosition(BlockPos pos, Predicate<BlockState> state) {
        return this.level.isStateAtPosition(pos, state);
    }

    public boolean isFluidAtPosition(BlockPos pos, Predicate<FluidState> predicate) {
        return this.level.isFluidAtPosition(pos, predicate);
    }

    public boolean setBlock(BlockPos pos, BlockState state, int flags, int recursionLeft) {
        if (this.level.setBlock(pos, state, flags, recursionLeft)) {
            BlockPos immutablePos = pos.immutable();
            this.modifiedBlocks.add(immutablePos);
            this.onSetBlock.accept(immutablePos);
            return true;
        }
        return false;
    }

    public boolean removeBlock(BlockPos pos, boolean isMoving) {
        return this.level.removeBlock(pos, isMoving);
    }

    public boolean destroyBlock(BlockPos pos, boolean dropBlock, Entity entity, int recursionLeft) {
        return this.level.destroyBlock(pos, dropBlock, entity, recursionLeft);
    }
}

