/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Supplier;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.swedz.tesseract.neoforge.Tesseract;
import net.swedz.tesseract.neoforge.config.ConfigEntry;
import net.swedz.tesseract.neoforge.config.ConfigManager;
import net.swedz.tesseract.neoforge.config.ConfigManagerArg;
import net.swedz.tesseract.neoforge.config.annotation.ConfigKey;
import net.swedz.tesseract.neoforge.config.annotation.SubSection;
import net.swedz.tesseract.neoforge.helper.NamingConventionHelper;
import net.swedz.tesseract.neoforge.interfaceproxy.InterfaceProxyHandler;
import net.swedz.tesseract.neoforge.serialization.TomlOps;

public final class ConfigHandler
extends InterfaceProxyHandler<ConfigEntry> {
    private final ConfigManager manager;
    private final ModConfigSpec spec;
    private final String path;

    public ConfigHandler(ConfigManager manager, ModConfigSpec spec, String path) {
        this.manager = manager;
        this.spec = spec;
        this.path = path;
    }

    ModConfigSpec spec() {
        return this.spec;
    }

    String path() {
        return this.path;
    }

    private String path(String key) {
        return (String)(this.path.isEmpty() ? "" : this.path + ".") + key;
    }

    private Supplier<Object> loadValue(Object proxy, Method method, String path) {
        ModConfigSpec.ConfigValue configValue = (ModConfigSpec.ConfigValue)this.spec.getValues().get(path);
        if (this.manager.codecs().has(method.getReturnType())) {
            Codec<?> codec = this.manager.codecs().get(method.getReturnType());
            return () -> codec.parse((DynamicOps)TomlOps.INSTANCE, configValue.get()).mapOrElse(result -> result, error -> {
                Tesseract.LOGGER.error("Failed to parse input value: {}", (Object)error.message());
                try {
                    return InvocationHandler.invokeDefault(proxy, method, new Object[0]);
                }
                catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        return () -> ((ModConfigSpec.ConfigValue)configValue).get();
    }

    @Override
    protected Optional<ConfigEntry> generate(Class<?> proxyClass, Object proxy, Method method) {
        if (method.isAnnotationPresent(ConfigKey.class)) {
            String key = method.getAnnotation(ConfigKey.class).value();
            if (key.isEmpty()) {
                key = NamingConventionHelper.fromCamelCaseToSnakeCase(method);
            }
            String path = this.path(key);
            Class<?> type = method.getReturnType();
            Object value = method.isAnnotationPresent(SubSection.class) ? this.manager.build(type, new ConfigManagerArg(Optional.of(this.spec), path)).load() : this.loadValue(proxy, method, path);
            return Optional.of(new ConfigEntry(value));
        }
        return Optional.empty();
    }
}

